/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service.ws;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.poll.service.PollSummary;
import org.exoplatform.poll.service.Utils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="ks/poll")
public class PollWebservice
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(PollWebservice.class);
    public static final String APP_TYPE = "poll".intern();

    @GET
    @Path(value="/viewpoll/{resourceid}")
    @Produces(value={"application/json"})
    public Response viewPoll(@PathParam(value="resourceid") String pollId) throws Exception {
        PollService pollService;
        CacheControl cacheControl;
        block7: {
            cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
            if (!Utils.isEmpty(pollId)) {
                try {
                    Poll poll = pollService.getPoll(pollId);
                    if (poll == null) break block7;
                    poll.setIsAdmin("true");
                    String group = poll.getParentPath();
                    boolean hasPerminsion = false;
                    if (group.indexOf(PollNodeTypes.APPLICATION_DATA) > 0 && poll.getIsAdmin().equals("false")) {
                        group = group.substring(group.indexOf(PollNodeTypes.GROUPS + "/") + PollNodeTypes.GROUPS.length(), group.indexOf("/" + PollNodeTypes.APPLICATION_DATA));
                        for (String group_ : this.getGroupsOfUser()) {
                            if (group_.indexOf(group) < 0) continue;
                            hasPerminsion = true;
                            break;
                        }
                    } else {
                        hasPerminsion = group.indexOf(PollNodeTypes.POLLS) < 0 ? pollService.hasPermissionInForum(group + "/" + poll.getId(), this.getAllGroupAndMembershipOfUser()) : true;
                    }
                    if (!hasPerminsion) {
                        poll = new Poll();
                        poll.setId("DoNotPermission");
                        return Response.ok((Object)poll, (String)"application/json").cacheControl(cacheControl).build();
                    }
                    poll.setVotes();
                    poll.setInfoVote();
                    poll.setShowVote(this.isGuestPermission(poll));
                    return Response.ok((Object)poll, (String)"application/json").cacheControl(cacheControl).build();
                }
                catch (Exception e) {
                    log.error((Object)("Can not get poll by id: " + pollId), (Throwable)e);
                }
            }
        }
        PollSummary pollSummary = new PollSummary();
        pollSummary = pollService.getPollSummary(this.getAllGroupAndMembershipOfUser());
        pollSummary.setIsAdmin("true");
        return Response.ok((Object)pollSummary, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/votepoll/{pollId}/{indexVote}")
    @Produces(value={"application/json"})
    public Response votePoll(@PathParam(value="pollId") String pollId, @PathParam(value="indexVote") String indexVote) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        if (!Utils.isEmpty(pollId) && !Utils.isEmpty(indexVote)) {
            try {
                PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
                Poll poll = pollService.getPoll(pollId.trim());
                if (poll != null) {
                    poll = this.calculateVote(poll, this.getUserId(), indexVote);
                    pollService.savePoll(poll, false, true);
                    poll.setVotes();
                    poll.setInfoVote();
                    poll.setShowVote(this.isGuestPermission(poll));
                    poll.setIsAdmin(String.valueOf(this.hasGroupAdminOfGatein()));
                    return Response.ok((Object)poll, (String)"application/json").cacheControl(cacheControl).build();
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to vote poll.", (Throwable)e);
            }
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    private Poll calculateVote(Poll poll, String userVote, String optionVote) throws Exception {
        String[] temporary = poll.getUserVote();
        int size = 0;
        if (temporary != null && temporary.length > 0) {
            size = temporary.length;
        }
        if (!poll.getIsMultiCheck()) {
            int j = Integer.valueOf(optionVote);
            String[] setUserVote = new String[size + 1];
            System.arraycopy(temporary, 0, setUserVote, 0, size);
            setUserVote[size] = userVote + ":" + j;
            String[] votes = poll.getVote();
            double onePercent = 100.0 / (double)(++size);
            int i = 0;
            for (String vote : votes) {
                double d = Double.parseDouble(vote);
                votes[i] = i == j ? "" + (d - d / (double)size + onePercent) : "" + (d - d / (double)size);
                ++i;
            }
            poll.setVote(votes);
            poll.setUserVote(setUserVote);
        } else {
            ArrayList listValue = new ArrayList();
            String[] votes = poll.getVote();
            double totalVote = 0.0;
            double[] doubleVote = new double[votes.length];
            String[] listUserVoted = poll.getUserVote();
            if (listUserVoted.length > 0) {
                for (String string : listUserVoted) {
                    totalVote += (double)(string.split(":").length - 1);
                }
            }
            int i = 0;
            int pos = 0;
            if (votes != null && votes.length > 0) {
                for (String v : votes) {
                    doubleVote[i++] = Double.parseDouble(v);
                }
            }
            if (totalVote > 0.0) {
                for (i = 0; i < doubleVote.length; ++i) {
                    doubleVote[i] = doubleVote[i] * totalVote / 100.0;
                }
            }
            String[] setUserVote = poll.getUserVote();
            for (i = 0; i < setUserVote.length; ++i) {
                if (!setUserVote[i].split(":")[0].equals(userVote)) continue;
                pos = i;
                break;
            }
            String[] posHaveVoted = setUserVote[pos].substring(setUserVote[pos].indexOf(":")).split(":");
            setUserVote[pos] = setUserVote[pos].substring(0, setUserVote[pos].indexOf(":"));
            for (String posVoted : posHaveVoted) {
                if (!Utils.isEmpty(posVoted)) continue;
                int n = Integer.parseInt(posVoted);
                doubleVote[n] = doubleVote[n] - 1.0;
                totalVote -= 1.0;
            }
            i = 0;
            for (String option : poll.getOption()) {
                if (listValue.contains(option)) {
                    int n = i;
                    doubleVote[n] = doubleVote[n] + 1.0;
                    totalVote += 1.0;
                    int n2 = pos;
                    setUserVote[n2] = setUserVote[n2] + ":" + i;
                }
                ++i;
            }
            i = 0;
            for (double dv : doubleVote) {
                votes[i] = totalVote > 0.0 ? dv / totalVote * 100.0 + "" : "0";
                ++i;
            }
            poll.setUserVote(setUserVote);
            poll.setVote(votes);
        }
        return poll;
    }

    private boolean isGuestPermission(Poll poll_) throws Exception {
        String[] userVotes;
        Date today;
        if (poll_.getIsClosed()) {
            return true;
        }
        if (poll_.getTimeOut() > 0L && (today = Utils.getGreenwichMeanTime().getTime()).getTime() - poll_.getCreatedDate().getTime() >= poll_.getTimeOut() * 86400000L) {
            return true;
        }
        String username = this.getUserId();
        if (Utils.isEmpty(username)) {
            return true;
        }
        for (String string : userVotes = poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(":"))).equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    private boolean hasGroupAdminOfGatein() {
        try {
            UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
            ArrayList<String> list = new ArrayList<String>();
            Identity identity = ConversationState.getCurrent().getIdentity();
            list.add(identity.getUserId());
            list.addAll(identity.getGroups());
            for (String str : list) {
                if (!str.equals(userACL.getSuperUser()) && !str.equals(userACL.getAdminGroups())) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to check has group admin of gatein.", (Throwable)e);
        }
        return false;
    }

    private String getUserId() {
        String username = "";
        try {
            username = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return username;
    }

    private List<String> getAllGroupAndMembershipOfUser() {
        ArrayList<String> listOfUser = new ArrayList<String>();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            listOfUser.add(identity.getUserId());
            HashSet<String> list = new HashSet<String>();
            list.addAll(identity.getGroups());
            for (MembershipEntry membership : identity.getMemberships()) {
                String value = membership.getGroup();
                list.add(value);
                value = membership.getMembershipType() + ":" + value;
                list.add(value);
            }
            listOfUser.addAll(list);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to add all info of user.");
        }
        return listOfUser;
    }

    private List<String> getGroupsOfUser() {
        try {
            return new ArrayList<String>(ConversationState.getCurrent().getIdentity().getGroups());
        }
        catch (Exception e) {
            log.warn((Object)"Failed to add group of user.");
            return new ArrayList<String>();
        }
    }
}

