/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant.extractors;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ClassNamesExtractor {
    private static final Log LOG = ExoLogger.getLogger(ClassNamesExtractor.class);

    public static List<String> getCompiledClassesFromJar(String jarPath) throws IOException {
        return ClassNamesExtractor.getCompiledClassesFromJar(jarPath, null);
    }

    public static List<String> getCompiledClassesFromJar(String jarPath, String packageName) throws IOException {
        return ClassNamesExtractor.extract(jarPath, packageName, ".class");
    }

    public static List<String> getSourceClassesFromJar(String javaSrcPath) throws IOException {
        return ClassNamesExtractor.getSourceClassesFromJar(javaSrcPath, null);
    }

    public static List<String> getSourceClassesFromJar(String javaSrcPath, String packageName) throws IOException {
        return ClassNamesExtractor.extract(javaSrcPath, packageName, ".java");
    }

    private static List<String> extract(String archath, String packageName, String fileExtension) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        ArrayList<String> classes = new ArrayList<String>();
        ZipInputStream zipFile = new ZipInputStream(new FileInputStream(archath));
        while ((zipEntry = zipFile.getNextEntry()) != null) {
            if (!zipEntry.getName().endsWith(fileExtension)) continue;
            String fqn = zipEntry.getName();
            try {
                fqn = fqn.substring(0, fqn.lastIndexOf("."));
                fqn = fqn.replaceAll("/", "\\.");
                if (packageName != null) {
                    if (!fqn.startsWith(packageName)) continue;
                    classes.add(fqn);
                    continue;
                }
                classes.add(fqn);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not add class " + fqn));
            }
        }
        return classes;
    }
}

