/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.service.rest.LinkShare;
import org.exoplatform.social.service.rest.LinkShareRequest;
import org.exoplatform.social.service.rest.Util;

@Path(value="social/linkshare")
public class LinkShareRestService
implements ResourceContainer {
    private LinkShare getLinkShare(String link, String lang) throws Exception {
        LinkShare ls;
        if (link == null || link.length() == 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ls = lang != null ? LinkShare.getInstance(link, lang) : LinkShare.getInstance(link);
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return ls;
    }

    @POST
    @Path(value="show.{format}")
    @Consumes(value={"application/json", "application/xml"})
    public Response getLink(@Context UriInfo uriInfo, @PathParam(value="format") String format, LinkShareRequest linkShareRequest) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        if (linkShareRequest == null || !linkShareRequest.verify()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        LinkShare linkShare = null;
        linkShare = this.getLinkShare(linkShareRequest.getLink(), linkShareRequest.getLang());
        return Util.getResponse((Object)linkShare, uriInfo, mediaType, Response.Status.OK);
    }
}

