/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinAssociations;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public class CreateFileAssociationAction
extends SystemAutoUninstallInstallAction {
    private String extension = "";
    private String description = "";
    private String launcherId = "";
    private boolean selected = false;
    private boolean windows = true;
    private ExternalFile windowsIconFile = null;
    private boolean mac = true;
    private ExternalFile macIconFile = null;
    private boolean restartFinder = false;
    private static final String PROP_EXTENSION = "extension";
    private static final String PROP_EXECUTABLE = "executable";
    private static boolean finderRestarted = false;

    public boolean isRestartFinder() {
        return this.restartFinder;
    }

    public void setRestartFinder(boolean bl) {
        this.restartFinder = bl;
    }

    public String getExtension() {
        return CreateFileAssociationAction.replaceVariables(this.extension);
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getDescription() {
        return CreateFileAssociationAction.replaceVariables(this.description);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public void setWindows(boolean bl) {
        this.windows = bl;
    }

    public ExternalFile getWindowsIconFile() {
        return this.windowsIconFile;
    }

    public void setWindowsIconFile(ExternalFile externalFile) {
        this.windowsIconFile = externalFile;
    }

    public boolean isMac() {
        return this.mac;
    }

    public void setMac(boolean bl) {
        this.mac = bl;
    }

    public ExternalFile getMacIconFile() {
        return this.macIconFile;
    }

    public void setMacIconFile(ExternalFile externalFile) {
        this.macIconFile = externalFile;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (!this.isSelected()) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows() && this.isWindows()) {
                return this.installWindows(installerContext);
            }
            if (InstallerUtil.isMacOS() && this.isMac()) {
                return this.installMac(installerContext);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean uninstall(UninstallerContext uninstallerContext) {
        try {
            if (InstallerUtil.isWindows()) {
                this.uninstallWindows();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    private void uninstallWindows() throws IOException {
        Properties properties = this.getPersistentProperties();
        String string = properties.getProperty(PROP_EXTENSION);
        String string2 = properties.getProperty(PROP_EXECUTABLE);
        if (string2 == null || string == null) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        File file = new File(string2).getCanonicalFile();
        String string3 = WinAssociations.getExecutable(string);
        if (string3 != null && new File(string3).getCanonicalFile().equals(file)) {
            WinAssociations.remove(string);
        }
    }

    private boolean installWindows(InstallerContext installerContext) throws UserCanceledException {
        File file = this.getExecutableFile(installerContext);
        if (file == null || !file.exists()) {
            return false;
        }
        File file2 = installerContext.getExternalFile(this.getWindowsIconFile(), true);
        String string = this.getExtension();
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        if (FileAssociations.exists(string)) {
            this.addRollbackActions(FileAssociations.remove(string));
        }
        this.addRollbackActions(FileAssociations.create(string, this.getDescription(), file2, file));
        Properties properties = this.getPersistentProperties();
        properties.setProperty(PROP_EXTENSION, string);
        properties.setProperty(PROP_EXECUTABLE, file.getAbsolutePath());
        return true;
    }

    private boolean installMac(InstallerContext installerContext) throws IOException {
        File file = this.getBundleDir(installerContext);
        if (file != null && file.exists()) {
            File file2 = new File(file, "Contents/Info.plist");
            if (file2.exists()) {
                CreateFileAssociationAction.addAssociation(file2, this.getExtension(), this.getDescription(), installerContext.getExternalFile(this.getMacIconFile(), true));
                this.refresh(file);
                return true;
            }
            Util.logError(this, "infoPlistFile not found: " + file2);
        } else {
            Util.logError(this, "bundleDir not found: " + file);
        }
        return false;
    }

    private File getBundleDir(Context context) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file = null;
        if (installerConfig.getMacSpecificConfig().isSingleBundle()) {
            file = context.getDestinationFile(installerConfig.getMacSpecificConfig().getSingleBundleName());
        } else {
            LauncherConfig launcherConfig = installerConfig.getLauncherConfigById(this.getLauncherId());
            if (launcherConfig != null) {
                file = context.getDestinationFile(launcherConfig.getFile());
            }
        }
        return file;
    }

    private File getExecutableFile(Context context) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        LauncherConfig launcherConfig = installerConfig.getLauncherConfigById(this.getLauncherId());
        if (launcherConfig == null) {
            return null;
        }
        return context.getDestinationFile(launcherConfig.getFile());
    }

    private void refresh(File file) {
        try {
            if (!Execution.executeAndWait(new String[]{"/System/Library/Frameworks/ApplicationServices.framework/Frameworks/LaunchServices.framework/Support/lsregister", "-R", "-f", file.getAbsolutePath()}, null)) {
                Util.logError(this, "refresh db not successful");
            }
        }
        catch (IOException iOException) {
            Util.logError(this, "could not refresh db: " + iOException.getMessage());
        }
        if (this.restartFinder && !finderRestarted) {
            finderRestarted = true;
            Runtime.getRuntime().addShutdownHook(new Thread("finder restart"){

                public void run() {
                    try {
                        Runtime.getRuntime().exec("killall -SIGHUP Finder");
                    }
                    catch (IOException iOException) {
                        System.err.println("could not restart finder: " + iOException.getMessage());
                    }
                }
            });
        }
    }

    private static void addAssociation(File file, String string, String string2, File file2) throws IOException {
        File file3;
        if (file2 != null) {
            file3 = new File(new File(file.getParentFile(), "Resources"), file2.getName());
            FileUtil.copyFile(file2, file3);
            FileInstaller.getInstance().registerUninstallFile(file3);
        }
        file3 = new File(file.getAbsolutePath() + ".temp");
        file3.delete();
        file.renameTo(file3);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            printWriter.println(string3);
            if (string3.trim().equals("<!-- I4J_INSERT_DOCTYPE -->")) {
                CreateFileAssociationAction.insertAssociation(printWriter, string, string2, file2);
            }
            string3 = bufferedReader.readLine();
        }
        printWriter.close();
        bufferedReader.close();
        file3.delete();
    }

    private static void insertAssociation(PrintWriter printWriter, String string, String string2, File file) {
        printWriter.println("<dict>");
        printWriter.println("<key>CFBundleTypeExtensions</key>");
        printWriter.println("<array>");
        printWriter.println("<string>" + string + "</string>");
        printWriter.println("</array>");
        printWriter.println("<key>CFBundleTypeName</key>");
        printWriter.println("<string>" + string2 + "</string>");
        if (file != null) {
            printWriter.println("<key>CFBundleTypeIconFile</key>");
            printWriter.println("<string>" + file.getName() + "</string>");
        }
        printWriter.println("<key>CFBundleTypeRole</key>");
        printWriter.println("<string>Viewer</string>");
        printWriter.println("</dict>");
    }

    public void rollback(InstallerContext installerContext) {
        super.rollback(installerContext);
        if (InstallerUtil.isWindows()) {
            Registry.changeNotifyAssociations();
        }
    }

    public boolean fileExists(Context context) {
        File file = null;
        if (Util.isWindowsInstaller()) {
            file = this.getExecutableFile(context);
        } else if (Util.isMacosInstaller()) {
            file = this.getBundleDir(context);
        }
        return file != null && file.exists();
    }
}

