/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.ext.impl.CalendarSpaceActivityPublisher;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/cs/social-integration/plugin/space/CalendarUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={MoreEventInfoActionListener.class}), @EventConfig(listeners={AcceptEventActionListener.class}), @EventConfig(listeners={AssignTaskActionListener.class}), @EventConfig(listeners={SetTaskStatusActionListener.class})})
public class CalendarUIActivity
extends BaseUIActivity {
    private static final Log log = ExoLogger.getLogger(CalendarUIActivity.class);
    private boolean displayMoreInfo = false;
    private boolean isAnswered = false;
    private boolean isInvited = false;
    private boolean isTaskAssignedToMe = false;
    private boolean isTaskDone = false;
    private String taskStatus;
    private String eventId;
    private String calendarId;
    SimpleDateFormat dformat = new SimpleDateFormat("dd/MM/yyyy hh:mm");

    public void init() {
        block10: {
            try {
                this.eventId = (String)this.getActivity().getTemplateParams().get(CalendarSpaceActivityPublisher.EVENT_ID_KEY);
                this.calendarId = (String)this.getActivity().getTemplateParams().get(CalendarSpaceActivityPublisher.CALENDAR_ID_KEY);
                User user = (User)ConversationState.getCurrent().getAttribute("UserProfile");
                String username = user.getUserName();
                CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                CalendarEvent event = null;
                event = calService.getGroupEvent(this.calendarId, this.eventId);
                HashMap<String, String> pars = new HashMap<String, String>();
                if (event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) && event.getParticipantStatus() != null) {
                    for (String part : event.getParticipantStatus()) {
                        String[] entry = part.split(":");
                        if (entry.length > 1) {
                            pars.put(entry[0], entry[1]);
                            continue;
                        }
                        pars.put(entry[0], Utils.EMPTY_STR);
                    }
                    if (pars.containsKey(username)) {
                        this.isInvited = true;
                        if (((String)pars.get(username)).equalsIgnoreCase(Utils.STATUS_YES) || ((String)pars.get(username)).equalsIgnoreCase(Utils.STATUS_NO)) {
                            this.isAnswered = true;
                        }
                    }
                } else if (event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_TASK)) {
                    this.taskStatus = event.getEventState();
                    String taskDelegator = event.getTaskDelegator();
                    if (taskDelegator != null && taskDelegator.indexOf(user.getUserName()) >= 0) {
                        this.isTaskAssignedToMe = true;
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)("Could not calculate values of Calendar activity with event(task): " + this.eventId), (Throwable)e);
            }
        }
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public boolean isTaskAssigned() {
        return this.isTaskAssignedToMe;
    }

    public boolean isTaskDone() {
        return this.isTaskDone;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public boolean isAnswered() {
        return this.isAnswered;
    }

    public boolean isInvited() {
        return this.isInvited;
    }

    public boolean isDisplayMoreInfo() {
        return this.displayMoreInfo;
    }

    public void setDisplayMoreInfo(boolean displayMoreInfo) {
        this.displayMoreInfo = displayMoreInfo;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value;
    }

    public String getTypeOfEvent() {
        String type = "";
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            type = (String)params.get(CalendarSpaceActivityPublisher.EVENT_TYPE_KEY);
        }
        return type;
    }

    public String getEventStartTime(WebuiBindingContext ctx) {
        String timeStr = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_STARTTIME_KEY);
        if (timeStr == null) {
            return "";
        }
        long time = Long.valueOf(timeStr);
        return this.getDateString(ctx, time);
    }

    public String getDescription() {
        String des = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_DESCRIPTION_KEY);
        if (des == null) {
            des = "";
        }
        return des;
    }

    public String getLocation() {
        String des = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_LOCALE_KEY);
        if (des == null) {
            des = "";
        }
        return des;
    }

    public String getEventEndTime(WebuiBindingContext ctx) {
        String timeStr = this.getActivityParamValue(CalendarSpaceActivityPublisher.EVENT_ENDTIME_KEY);
        if (timeStr == null) {
            return "";
        }
        long time = Long.valueOf(timeStr);
        return this.getDateString(ctx, time);
    }

    public String getDateString(WebuiBindingContext ctx, long time) {
        WebuiRequestContext requestContext = ctx.getRequestContext();
        Locale locale = requestContext.getLocale();
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTimeInMillis(time);
        return this.dformat.format(calendar.getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetTaskStatusActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            WebuiRequestContext requestContext;
            CalendarUIActivity uiComponent;
            block3: {
                uiComponent = (CalendarUIActivity)((Object)event.getSource());
                requestContext = event.getRequestContext();
                String param = requestContext.getRequestParameter("objectId");
                try {
                    CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    if (param != null && !param.equalsIgnoreCase(uiComponent.getTaskStatus())) {
                        calService.setGroupTaskStatus(uiComponent.getEventId(), uiComponent.getCalendarId(), param);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Could not set task status for task: " + uiComponent.getEventId()), (Throwable)e);
                }
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignTaskActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            WebuiRequestContext requestContext;
            CalendarUIActivity uiComponent;
            block3: {
                uiComponent = (CalendarUIActivity)((Object)event.getSource());
                requestContext = event.getRequestContext();
                if (!uiComponent.isTaskAssigned()) {
                    try {
                        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                        String remoteUser = requestContext.getRemoteUser();
                        calService.assignGroupTask(uiComponent.getEventId(), uiComponent.getCalendarId(), remoteUser);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block3;
                        log.warn((Object)("Could not assign user for task: " + uiComponent.getEventId()), (Throwable)e);
                    }
                }
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptEventActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            WebuiRequestContext requestContext;
            CalendarUIActivity uiComponent;
            block5: {
                uiComponent = (CalendarUIActivity)((Object)event.getSource());
                requestContext = event.getRequestContext();
                String paramStr = requestContext.getRequestParameter("objectId");
                if (!uiComponent.isAnswered()) {
                    boolean isAccepted = false;
                    if (paramStr != null) {
                        isAccepted = Boolean.parseBoolean(paramStr);
                    }
                    try {
                        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                        User user = (User)ConversationState.getCurrent().getAttribute("UserProfile");
                        int answer = 0;
                        if (isAccepted) {
                            answer = 1;
                        }
                        calService.confirmInvitation(user.getUserName(), user.getEmail(), user.getUserName(), 2, uiComponent.getCalendarId(), uiComponent.getEventId(), answer);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)("Could not answer the invitation of event: " + uiComponent.getEventId()), (Throwable)e);
                    }
                }
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoreEventInfoActionListener
    extends EventListener<CalendarUIActivity> {
        public void execute(Event<CalendarUIActivity> event) throws Exception {
            CalendarUIActivity uiComponent = (CalendarUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            boolean display = uiComponent.isDisplayMoreInfo();
            uiComponent.setDisplayMoreInfo(!display);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }
}

