/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import java.util.Vector;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.ActiveComponent;
import net.wimpi.telnetd.io.toolkit.BufferOverflowException;
import net.wimpi.telnetd.io.toolkit.Dimension;
import net.wimpi.telnetd.io.toolkit.Editline;

public class Editarea
extends ActiveComponent {
    private int m_ColCursor = 0;
    private int m_RowCursor = 0;
    private int m_Rows = 0;
    private boolean m_Firstrun = true;
    private int m_FirstVisibleRow = 0;
    private int m_LastCursor = 0;
    private String m_Hardwrap = "\n";
    private String m_Softwrap = " ";
    private Vector lines = new Vector();
    private Editline line;

    public Editarea(BasicTerminalIO io, String name, int rowheight, int maxrows) {
        super(io, name);
        this.m_Rows = maxrows;
        this.m_Firstrun = true;
        this.m_FirstVisibleRow = 0;
        this.setDimension(new Dimension(this.m_IO.getColumns(), rowheight));
    }

    public int getSize() {
        int size = 0;
        return size;
    }

    public void setHardwrapString(String str) {
        this.m_Hardwrap = str;
    }

    public String getHardwrapString() {
        return this.m_Hardwrap;
    }

    public void setSoftwrapString(String str) {
        this.m_Softwrap = str;
    }

    public String getSoftwrapString() {
        return this.m_Softwrap;
    }

    public String getValue() {
        StringBuffer sbuf = new StringBuffer();
        Editline el = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            el = this.getLine(i);
            sbuf.append(el.getValue()).append(el.isHardwrapped() ? this.m_Hardwrap : this.m_Softwrap);
        }
        return sbuf.toString();
    }

    public void setValue(String str) throws BufferOverflowException {
        this.lines.removeAllElements();
        this.m_RowCursor = 0;
        this.m_ColCursor = 0;
    }

    public void clear() throws IOException {
        this.lines.removeAllElements();
        this.m_RowCursor = 0;
        this.m_ColCursor = 0;
        this.draw();
    }

    public void run() throws IOException {
        boolean oldcursor = false;
        boolean done = false;
        this.m_IO.setAutoflushing(false);
        if (this.m_Firstrun) {
            this.m_Firstrun = false;
            this.line = this.createLine();
            this.appendLine(this.line);
        }
        do {
            switch (this.line.run()) {
                case 1001: {
                    if (this.m_RowCursor > 0) {
                        if (this.m_FirstVisibleRow == this.m_RowCursor) {
                            this.scrollUp();
                            break;
                        }
                        this.cursorUp();
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1002: {
                    if (this.m_RowCursor < this.lines.size() - 1) {
                        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
                            this.scrollDown();
                            break;
                        }
                        this.cursorDown();
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 10: {
                    if (this.m_RowCursor == this.m_Rows - 1) {
                        done = true;
                        break;
                    }
                    if (!this.hasLineSpace()) {
                        this.m_IO.bell();
                        break;
                    }
                    String wrap = this.line.getHardwrap();
                    this.line.setHardwrapped(true);
                    if (this.m_RowCursor == this.lines.size() - 1) {
                        this.appendNewLine();
                    } else {
                        this.insertNewLine();
                    }
                    ++this.m_RowCursor;
                    this.activateLine(this.m_RowCursor);
                    try {
                        this.line.setValue(wrap);
                        this.line.setCursorPosition(0);
                        this.m_IO.moveLeft(this.line.size());
                    }
                    catch (Exception ex) {}
                    break;
                }
                case 1301: {
                    done = true;
                    break;
                }
                case 1004: {
                    if (this.m_RowCursor > 0) {
                        if (this.m_FirstVisibleRow == this.m_RowCursor) {
                            this.scrollUp();
                            this.line.setCursorPosition(this.line.size());
                            this.m_IO.moveRight(this.line.size());
                            break;
                        }
                        --this.m_RowCursor;
                        this.activateLine(this.m_RowCursor);
                        this.line.setCursorPosition(this.line.size());
                        this.m_IO.moveUp(1);
                        this.m_IO.moveRight(this.line.size());
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1003: {
                    if (this.m_RowCursor < this.lines.size() - 1) {
                        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
                            this.line.setCursorPosition(0);
                            this.m_IO.moveLeft(this.line.size());
                            this.scrollDown();
                            break;
                        }
                        ++this.m_RowCursor;
                        this.m_IO.moveLeft(this.line.size());
                        this.activateLine(this.m_RowCursor);
                        this.line.setCursorPosition(0);
                        this.m_IO.moveDown(1);
                        break;
                    }
                    this.m_IO.bell();
                    break;
                }
                case 1303: {
                    if (this.m_RowCursor == 0 || this.line.size() != 0 || this.m_RowCursor == this.m_FirstVisibleRow) {
                        this.m_IO.bell();
                        break;
                    }
                    this.removeLine();
                    break;
                }
                default: {
                    if (!this.hasLineSpace()) {
                        this.m_IO.bell();
                        break;
                    }
                    String wrap = this.line.getSoftwrap();
                    this.line.setHardwrapped(false);
                    if (this.m_RowCursor == this.lines.size() - 1) {
                        this.appendNewLine();
                    } else {
                        this.insertNewLine();
                    }
                    ++this.m_RowCursor;
                    this.activateLine(this.m_RowCursor);
                    try {
                        this.line.setValue(wrap);
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.m_IO.flush();
        } while (!done);
    }

    private void scrollUp() throws IOException {
        int horizontalpos = this.line.getCursorPosition();
        --this.m_FirstVisibleRow;
        --this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(horizontalpos);
        int lasthorizontal = horizontalpos;
        int count = 0;
        for (int i = this.m_FirstVisibleRow; i < this.m_FirstVisibleRow + this.m_Dim.getHeight() && i < this.lines.size(); ++i) {
            this.m_IO.moveLeft(lasthorizontal);
            Editline lin = (Editline)this.lines.elementAt(i);
            lasthorizontal = lin.size();
            this.m_IO.eraseToEndOfLine();
            this.m_IO.write(lin.getValue());
            this.m_IO.moveDown(1);
            ++count;
        }
        this.m_IO.moveUp(count);
        if (lasthorizontal > horizontalpos) {
            this.m_IO.moveLeft(lasthorizontal - horizontalpos);
        } else if (lasthorizontal < horizontalpos) {
            this.m_IO.moveRight(horizontalpos - lasthorizontal);
        }
        if (horizontalpos > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(horizontalpos - this.line.getCursorPosition());
        }
    }

    private void cursorUp() throws IOException {
        int horizontalpos = this.line.getCursorPosition();
        --this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(horizontalpos);
        this.m_IO.moveUp(1);
        if (horizontalpos > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(horizontalpos - this.line.getCursorPosition());
        }
    }

    private void scrollDown() throws IOException {
        int horizontalpos = this.line.getCursorPosition();
        ++this.m_FirstVisibleRow;
        ++this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(horizontalpos);
        this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
        int lasthorizontal = horizontalpos;
        for (int i = this.m_FirstVisibleRow; i < this.m_FirstVisibleRow + this.m_Dim.getHeight(); ++i) {
            this.m_IO.moveLeft(lasthorizontal);
            Editline lin = (Editline)this.lines.elementAt(i);
            lasthorizontal = lin.size();
            this.m_IO.eraseToEndOfLine();
            this.m_IO.write(lin.getValue());
            this.m_IO.moveDown(1);
        }
        this.m_IO.moveUp(1);
        if (lasthorizontal > horizontalpos) {
            this.m_IO.moveLeft(lasthorizontal - horizontalpos);
        } else if (lasthorizontal < horizontalpos) {
            this.m_IO.moveRight(horizontalpos - lasthorizontal);
        }
        if (horizontalpos > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(horizontalpos - this.line.getCursorPosition());
        }
    }

    private void cursorDown() throws IOException {
        int horizontalpos = this.line.getCursorPosition();
        ++this.m_RowCursor;
        this.activateLine(this.m_RowCursor);
        this.line.setCursorPosition(horizontalpos);
        this.m_IO.moveDown(1);
        if (horizontalpos > this.line.getCursorPosition()) {
            this.m_IO.moveLeft(horizontalpos - this.line.getCursorPosition());
        }
    }

    private void appendNewLine() throws IOException {
        this.appendLine(this.createLine());
        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
            ++this.m_FirstVisibleRow;
            this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
            this.m_IO.moveLeft(this.line.getCursorPosition());
            int lasthorizontal = this.line.getCursorPosition();
            for (int i = this.m_FirstVisibleRow; i < this.m_FirstVisibleRow + this.m_Dim.getHeight(); ++i) {
                Editline lin = (Editline)this.lines.elementAt(i);
                this.m_IO.eraseToEndOfLine();
                this.m_IO.write(lin.getValue());
                this.m_IO.moveLeft(lin.size());
                this.m_IO.moveDown(1);
            }
            this.m_IO.moveUp(1);
        } else {
            this.m_IO.moveLeft(this.line.getCursorPosition());
            this.m_IO.moveDown(1);
        }
    }

    private void insertNewLine() throws IOException {
        this.insertLine(this.m_RowCursor + 1, this.createLine());
        if (this.m_RowCursor == this.m_FirstVisibleRow + (this.m_Dim.getHeight() - 1)) {
            ++this.m_FirstVisibleRow;
            this.m_IO.moveUp(this.m_Dim.getHeight() - 1);
            int lasthorizontal = this.line.getCursorPosition();
            for (int i = this.m_FirstVisibleRow; i < this.m_FirstVisibleRow + this.m_Dim.getHeight(); ++i) {
                this.m_IO.moveLeft(lasthorizontal);
                Editline lin = (Editline)this.lines.elementAt(i);
                lasthorizontal = lin.size();
                this.m_IO.eraseToEndOfLine();
                this.m_IO.write(lin.getValue());
                this.m_IO.moveDown(1);
            }
            this.m_IO.moveUp(1);
        } else {
            this.m_IO.moveDown(1);
            this.m_IO.moveLeft(this.line.getCursorPosition());
            int count = 0;
            for (int i = this.m_RowCursor + 1; i < this.m_FirstVisibleRow + this.m_Dim.getHeight() && i < this.lines.size(); ++i) {
                this.m_IO.eraseToEndOfLine();
                Editline lin = (Editline)this.lines.elementAt(i);
                this.m_IO.write(lin.getValue());
                this.m_IO.moveLeft(lin.size());
                this.m_IO.moveDown(1);
                ++count;
            }
            this.m_IO.moveUp(count);
        }
    }

    private void removeLine() throws IOException {
        this.deleteLine(this.m_RowCursor);
        this.activateLine(this.m_RowCursor - 1);
        --this.m_RowCursor;
        boolean lasthorizontal = false;
        int count = 0;
        for (int i = this.m_RowCursor + 1; i < this.m_FirstVisibleRow + this.m_Dim.getHeight(); ++i) {
            if (i < this.lines.size()) {
                this.m_IO.eraseToEndOfLine();
                Editline lin = (Editline)this.lines.elementAt(i);
                this.m_IO.write(lin.getValue());
                this.m_IO.moveLeft(lin.size());
                this.m_IO.moveDown(1);
                ++count;
                continue;
            }
            this.m_IO.eraseToEndOfLine();
            this.m_IO.moveDown(1);
            ++count;
        }
        this.m_IO.moveUp(count + 1);
        this.line.setCursorPosition(this.line.size());
        this.m_IO.moveRight(this.line.size());
    }

    public void draw() throws IOException {
        if (this.m_Position != null) {
            this.m_IO.setCursor(this.m_Position.getRow(), this.m_Position.getColumn());
            int count = 0;
            for (int i = this.m_FirstVisibleRow; i < this.m_FirstVisibleRow + this.m_Dim.getHeight() && i < this.lines.size(); ++i) {
                this.m_IO.eraseToEndOfLine();
                Editline lin = (Editline)this.lines.elementAt(i);
                this.m_IO.write(lin.getValue());
                this.m_IO.moveLeft(lin.size());
                this.m_IO.moveDown(1);
                ++count;
            }
            int corr = this.m_FirstVisibleRow + count - this.m_RowCursor;
            if (corr > 0) {
                this.m_IO.moveUp(corr);
            }
        }
        this.m_IO.flush();
    }

    private void activateLine(int pos) {
        this.line = this.getLine(pos);
    }

    private boolean hasLineSpace() {
        return this.lines.size() < this.m_Rows;
    }

    private Editline createLine() {
        return new Editline(this.m_IO);
    }

    private void deleteLine(int pos) {
        this.lines.removeElementAt(pos);
    }

    private void insertLine(int pos, Editline el) {
        this.lines.insertElementAt(el, pos);
    }

    private void appendLine(Editline el) {
        this.lines.addElement(el);
    }

    private Editline getLine(int pos) {
        return (Editline)this.lines.elementAt(pos);
    }
}

