/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.chromattic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.chromattic.dataobject.CompilationSource;
import org.chromattic.dataobject.DataObjectCompiler;
import org.chromattic.dataobject.DataObjectService;
import org.chromattic.dataobject.NodeTypeFormat;
import org.exoplatform.ide.chromattic.MimeTypeResolver;
import org.exoplatform.ide.groovy.util.DependentResources;
import org.exoplatform.ide.groovy.util.GroovyScriptServiceUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyCompiler;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

@Path(value="/ide/chromattic/")
public class RestDataObjectService {
    public static final String WEBDAV_CONTEXT = "/jcr/";
    private RepositoryService repositoryService;
    private ThreadLocalSessionProviderService sessionProviderService;
    private JcrGroovyCompiler compiler;

    public RestDataObjectService(DataObjectService dataObjectService, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, NodeRepresentationService nodeRepresentationService, JcrGroovyCompiler compiler) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.compiler = compiler;
    }

    @POST
    @Path(value="/generate-nodetype-definition")
    public String getNodeTypeDefinition(@Context UriInfo uriInfo, @QueryParam(value="do-location") String location, @QueryParam(value="nodeTypeFormat") NodeTypeFormat format) throws PathNotFoundException, IOException, URISyntaxException {
        if (location == null) {
            throw new IllegalArgumentException("You must specify location of the source script.");
        }
        String[] jcrLocation = this.parseJcrLocation(uriInfo.getBaseUri().toASCIIString(), location);
        if (jcrLocation == null) {
            throw new PathNotFoundException("Location of script " + location + " not found. ");
        }
        String repository = jcrLocation[0];
        String workspace = jcrLocation[1];
        String path = "/" + jcrLocation[2];
        CompilationSource compilationSource = null;
        SourceFolder[] sources = null;
        DependentResources dependencyResources = GroovyScriptServiceUtil.getDependentResource((String)location, (String)uriInfo.getBaseUri().toASCIIString(), (RepositoryService)this.repositoryService, (ThreadLocalSessionProviderService)this.sessionProviderService);
        if (dependencyResources != null && dependencyResources.getFolderSources().size() > 0) {
            String dependencySource = (String)dependencyResources.getFolderSources().get(0);
            UnifiedNodeReference sourceReference = new UnifiedNodeReference(dependencySource);
            compilationSource = new CompilationSource(sourceReference.getRepository(), sourceReference.getWorkspace(), sourceReference.getPath());
            String dep = (String)dependencyResources.getFolderSources().get(0);
            sources = new SourceFolder[]{new SourceFolder(new UnifiedNodeReference(dep).getURL())};
        } else {
            compilationSource = new CompilationSource(repository, workspace, path);
        }
        SourceFile[] sourceFile = new SourceFile[]{new SourceFile(new UnifiedNodeReference(repository, workspace, path).getURL())};
        ArrayList<String> nodeReferences = new ArrayList<String>();
        URL[] urls = this.compiler.getDependencies(sources, sourceFile);
        for (int i = 0; i < urls.length; ++i) {
            if (!MimeTypeResolver.resolve(new UnifiedNodeReference(urls[i]), "application/x-chromattic+groovy")) continue;
            nodeReferences.add(new UnifiedNodeReference(urls[i]).getPath());
        }
        return new DataObjectCompiler(this.compiler, compilationSource, nodeReferences.toArray(new String[nodeReferences.size()])).generateSchema(format);
    }

    @POST
    @Path(value="/register-nodetype/{format}/{alreadyExistsBehaviour}")
    public void registerNodeType(@PathParam(value="format") NodeTypeFormat format, @PathParam(value="alreadyExistsBehaviour") Integer alreadyExistsBehaviour, InputStream nodeTypeDefinition) throws RepositoryException, RepositoryConfigurationException {
        NodeTypeManagerImpl nodeTypeManager = (NodeTypeManagerImpl)this.getRepository().getNodeTypeManager();
        switch (format) {
            case EXO: {
                nodeTypeManager.registerNodeTypes(nodeTypeDefinition, alreadyExistsBehaviour.intValue(), "text/xml");
                break;
            }
            case CND: {
                nodeTypeManager.registerNodeTypes(nodeTypeDefinition, alreadyExistsBehaviour.intValue(), "text/x-jcr-cnd");
                break;
            }
            default: {
                throw new RepositoryException("Unsupported content type:" + format.name());
            }
        }
    }

    private String[] parseJcrLocation(String baseUri, String location) {
        if (!location.startsWith(baseUri = baseUri + WEBDAV_CONTEXT)) {
            return null;
        }
        String[] elements = new String[3];
        location = location.substring(baseUri.length());
        elements[0] = location.substring(0, location.indexOf(47));
        location = location.substring(location.indexOf(47) + 1);
        elements[1] = location.substring(0, location.indexOf(47));
        elements[2] = location.substring(location.indexOf(47) + 1);
        return elements;
    }

    private ManageableRepository getRepository() throws RepositoryException, RepositoryConfigurationException {
        return this.repositoryService.getCurrentRepository() == null ? this.repositoryService.getDefaultRepository() : this.repositoryService.getCurrentRepository();
    }
}

