/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.artifacts;

import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;

public class CreatePortalArtifactsServiceImpl
implements CreatePortalArtifactsService {
    public static final String CREATE_PORTAL_EVENT = "PortalArtifactsInitializerServiceImpl.portal.onCreate";
    private HashMap<String, CreatePortalPlugin> artifactPlugins = new HashMap();
    private ArrayList<String> initialPortals = new ArrayList();
    private ListenerService listenerService;

    public CreatePortalArtifactsServiceImpl(InitParams initParams, ListenerService listenerService) {
        ValuesParam valuesParam = initParams.getValuesParam("ignored.portals");
        if (valuesParam != null) {
            this.initialPortals = valuesParam.getValues();
        }
        this.listenerService = listenerService;
    }

    public void addPlugin(CreatePortalPlugin artifactsPlugin) throws Exception {
        this.artifactPlugins.put(artifactsPlugin.getName(), artifactsPlugin);
    }

    public void deployArtifactsToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        if (this.initialPortals.contains(portalName)) {
            return;
        }
        for (CreatePortalPlugin plugin : this.artifactPlugins.values()) {
            plugin.deployToPortal(sessionProvider, portalName);
        }
        this.listenerService.broadcast(CREATE_PORTAL_EVENT, (Object)portalName, (Object)sessionProvider);
    }
}

