/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;

public class JavascriptManager {
    private ArrayList<String> data = new ArrayList(100);
    private ArrayList<String> customizedOnloadJavascript = null;
    private JavascriptConfigService jsSrevice_ = (JavascriptConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(JavascriptConfigService.class);

    public void addJavascript(CharSequence s) {
        if (s != null) {
            this.data.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.data.add(" \n");
        }
    }

    public void importJavascript(CharSequence s) {
        if (s != null && (!this.jsSrevice_.isModuleLoaded(s) || PropertyManager.isDevelopping())) {
            this.data.add("eXo.require('");
            this.data.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.data.add("'); \n");
        }
    }

    public void importJavascript(String s, String location) {
        if (s != null && location != null && (!this.jsSrevice_.isModuleLoaded(s) || PropertyManager.isDevelopping())) {
            this.data.add("eXo.require('");
            this.data.add(s);
            this.data.add("', '");
            this.data.add(location);
            if (!location.endsWith("/")) {
                this.data.add("/");
            }
            this.data.add("'); \n");
        }
    }

    public void addOnLoadJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            this.data.add("eXo.core.Browser.addOnLoadCallback('mid");
            this.data.add(id);
            this.data.add("',");
            this.data.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.data.add("); \n");
        }
    }

    public void addOnResizeJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            this.data.add("eXo.core.Browser.addOnResizeCallback('mid");
            this.data.add(id);
            this.data.add("',");
            this.data.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.data.add("); \n");
        }
    }

    public void addOnScrollJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            this.data.add("eXo.core.Browser.addOnScrollCallback('mid");
            this.data.add(id);
            this.data.add("',");
            this.data.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.data.add("); \n");
        }
    }

    public void writeJavascript(Writer writer) throws IOException {
        for (int i = 0; i < this.data.size(); ++i) {
            String s = this.data.get(i);
            writer.write(s);
        }
    }

    public void addCustomizedOnLoadScript(CharSequence s) {
        if (s != null) {
            if (this.customizedOnloadJavascript == null) {
                this.customizedOnloadJavascript = new ArrayList(30);
            }
            this.customizedOnloadJavascript.add(s instanceof String ? (String)s : ((Object)s).toString());
            this.customizedOnloadJavascript.add("\n");
        }
    }

    public void writeCustomizedOnLoadScript(Writer writer) throws IOException {
        if (this.customizedOnloadJavascript != null) {
            for (int i = 0; i < this.customizedOnloadJavascript.size(); ++i) {
                String s = this.customizedOnloadJavascript.get(i);
                writer.write(s);
            }
        }
    }
}

