/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeBrowser;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChild;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTreeWorkingArea.gtmpl", events={@EventConfig(listeners={PreviousActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UITaxonomyManager.msg.confirm-delete"), @EventConfig(listeners={CopyActionListener.class}), @EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={CutActionListener.class}), @EventConfig(listeners={ViewPermissionActionListener.class})})
public class UITaxonomyTreeWorkingArea
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    private List<NodeLocation> taxonomyNodes_;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UITaxonomyTreeWorkingArea");
    private ClipboardCommand clipboard_ = new ClipboardCommand();
    private String selectedPath_;
    private String[] acceptedNodeTypes = new String[0];
    private String[] actions_ = new String[]{"Previous"};

    public UITaxonomyTreeWorkingArea() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UICategoriesSelect");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid() throws Exception {
        ListAccessImpl nodeList = new ListAccessImpl(Object.class, this.getNodeList());
        LazyPageList dataPageList = new LazyPageList((ListAccess)nodeList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
    }

    public String[] getActions() {
        return this.actions_;
    }

    public List getListNodes() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPageIterator_.getCurrentPageData());
    }

    public void setNodeList(List<Node> nodes) {
        this.taxonomyNodes_ = NodeLocation.getLocationsByNodeList(nodes);
    }

    public List getNodeList() {
        return this.taxonomyNodes_;
    }

    public boolean isRootNode() throws Exception {
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        String selectedPath = uiManager.getSelectedPath();
        if (selectedPath == null) {
            selectedPath = uiManager.getRootNode().getPath();
        }
        return selectedPath.equals(uiManager.getRootNode().getPath());
    }

    boolean matchNodeType(Node node) throws Exception {
        if (this.acceptedNodeTypes == null || this.acceptedNodeTypes.length == 0) {
            return true;
        }
        for (String nodeType : this.acceptedNodeTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public void update() throws Exception {
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        if (this.selectedPath_ != null) {
            try {
                Node selectedTaxonomy = uiManager.getNodeByPath(this.selectedPath_);
                NodeIterator nodeIter = selectedTaxonomy.getNodes();
                ArrayList<Node> listNodes = new ArrayList<Node>();
                while (nodeIter.hasNext()) {
                    Node node = nodeIter.nextNode();
                    if (!this.matchNodeType(node)) continue;
                    listNodes.add(node);
                }
                this.setNodeList(listNodes);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        this.updateGrid();
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath_ = selectedPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviousActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)((UITaxonomyTreeWorkingArea)((Object)event.getSource())).getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyTreeData taxonomyTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UIActionTaxonomyManager uiActionTaxonomyManager = (UIActionTaxonomyManager)uiTaxonomyTreeContainer.getChild(UIActionTaxonomyManager.class);
            UIActionForm uiActionForm = (UIActionForm)uiActionTaxonomyManager.getChild(UIActionForm.class);
            uiActionForm.createNewAction(null, "exo:taxonomyAction", true);
            uiActionForm.setWorkspace(taxonomyTreeData.getTaxoTreeWorkspace());
            uiTaxonomyTreeContainer.viewStep(3);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewPermissionActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiManager = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiManager.getParent();
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIPopupContainer uiPopupContainer = uiTaxonomyTreeCreateChild.initPopupPermission("TaxonomyTreeViewPermissionPopup");
            UIPermissionManager uiPerMan = (UIPermissionManager)uiPopupContainer.createUIComponent(UIPermissionManager.class, null, null);
            ((UIPermissionInfo)uiPerMan.getChild(UIPermissionInfo.class)).setCurrentNode(uiTaxonomyTreeCreateChild.getNodeByPath(path));
            ((UIPermissionForm)uiPerMan.getChild(UIPermissionForm.class)).setCurrentNode(uiTaxonomyTreeCreateChild.getNodeByPath(path));
            uiPopupContainer.activate((UIComponent)uiPerMan, 650, 550);
            uiPopupContainer.setRendered(true);
            uiPerMan.checkPermissonInfo(uiTaxonomyTreeCreateChild.getNodeByPath(path));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CutActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiManager = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            uiManager.clipboard_.setType("cut");
            uiManager.clipboard_.setSrcPath(realPath);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiWorkingArea = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiWorkingArea.getParent();
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiWorkingArea.getAncestorOfType(UITaxonomyTreeContainer.class);
            TaxonomyTreeData taxoTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
            String type = uiWorkingArea.clipboard_.getType();
            String srcPath = uiWorkingArea.clipboard_.getSrcPath();
            if (type == null || srcPath == null) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.can-not-paste", null, 1));
                return;
            }
            if (type.equals("cut") && realPath.equals(srcPath)) {
                Object[] arg = new Object[]{realPath};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.node-is-cutting", arg, 1));
                return;
            }
            String destPath = realPath + srcPath.substring(srcPath.lastIndexOf("/"));
            Node realNode = uiTaxonomyTreeCreateChild.getNodeByPath(realPath);
            if (realNode.hasNode(srcPath.substring(srcPath.lastIndexOf("/") + 1))) {
                Object[] args = new Object[]{srcPath.substring(srcPath.lastIndexOf("/") + 1)};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.exist", args, 1));
                return;
            }
            TaxonomyService taxonomyService = (TaxonomyService)uiWorkingArea.getApplicationComponent(TaxonomyService.class);
            try {
                taxonomyService.moveTaxonomyNode(taxoTreeData.getTaxoTreeWorkspace(), srcPath, destPath, type);
                UITaxonomyTreeBrowser uiTaxonomyTreeBrowser = (UITaxonomyTreeBrowser)uiTaxonomyTreeCreateChild.getChild(UITaxonomyTreeBrowser.class);
                if (uiTaxonomyTreeBrowser != null && uiTaxonomyTreeBrowser.getSelectedNode() != null) {
                    uiWorkingArea.setSelectedPath(uiTaxonomyTreeBrowser.getSelectedNode().getPath());
                }
                uiTaxonomyTreeCreateChild.update();
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.referential-integrity", null, 1));
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyTreeCreateChild);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiManager = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            uiManager.clipboard_ = new ClipboardCommand();
            uiManager.clipboard_.setType("copy");
            uiManager.clipboard_.setSrcPath(realPath);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiTreeWorkingArea = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiTreeWorkingArea.getParent();
            UIApplication uiApp = (UIApplication)uiTreeWorkingArea.getAncestorOfType(UIApplication.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            Node selectedNode = uiTaxonomyTreeCreateChild.getNodeByPath(path);
            try {
                uiTreeWorkingArea.setSelectedPath(selectedNode.getParent().getPath());
                ((TaxonomyService)uiTreeWorkingArea.getApplicationComponent(TaxonomyService.class)).removeTaxonomyNode(uiTaxonomyTreeCreateChild.getWorkspace(), path);
            }
            catch (ReferentialIntegrityException ref) {
                Object[] arg = new Object[]{path};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.reference-exception", arg, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                Object[] arg = new Object[]{path};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.path-error", arg, 1));
                return;
            }
            if (uiTaxonomyTreeCreateChild.getChildById("TaxonomyPopupCreateChild") != null) {
                uiTaxonomyTreeCreateChild.removeChildById("TaxonomyPopupCreateChild");
            }
            uiTreeWorkingArea.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyTreeCreateChild);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UITaxonomyTreeWorkingArea> {
        public void execute(Event<UITaxonomyTreeWorkingArea> event) throws Exception {
            UITaxonomyTreeWorkingArea uiTreeWorkingArea = (UITaxonomyTreeWorkingArea)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiTreeWorkingArea.getParent();
            uiTaxonomyTreeCreateChild.initPopup(path);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyTreeCreateChild);
        }
    }
}

