/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LdapListAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLdapUserListAccess
extends LdapListAccess<User> {
    protected final String searchBase;
    protected final String filter;
    protected final LDAPAttributeMapping ldapAttrMapping;
    private int size = -1;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.SimpleLdapUserListAccess");

    public SimpleLdapUserListAccess(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, String searchBase, String filter) {
        super(ldapService);
        this.ldapAttrMapping = ldapAttrMapping;
        this.searchBase = searchBase;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User[] load(LdapContext ctx, int index, int length) throws Exception {
        User[] users = new User[length];
        NamingEnumeration<SearchResult> results = null;
        try {
            SortControl sctl = new SortControl(new String[]{this.ldapAttrMapping.userUsernameAttr}, false);
            ctx.setRequestControls(new Control[]{sctl});
            String[] returnedAtts = new String[]{this.ldapAttrMapping.userUsernameAttr, this.ldapAttrMapping.userFirstNameAttr, this.ldapAttrMapping.userLastNameAttr, this.ldapAttrMapping.userDisplayNameAttr, this.ldapAttrMapping.userMailAttr, this.ldapAttrMapping.userPassword};
            SearchControls constraints = new SearchControls();
            constraints.setReturningAttributes(returnedAtts);
            constraints.setSearchScope(2);
            results = ctx.search(this.searchBase, this.filter, constraints);
            int p = 0;
            int counter = 0;
            while (results.hasMoreElements() && counter < length) {
                SearchResult result = results.next();
                if (p >= index) {
                    User user = this.ldapAttrMapping.attributesToUser(result.getAttributes());
                    users[counter++] = user;
                }
                ++p;
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("range of users from " + index + " to " + (index + length)));
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getSize(LdapContext ctx) throws Exception {
        if (this.size < 0) {
            NamingEnumeration<SearchResult> results = null;
            try {
                String[] returnedAtts = new String[]{this.ldapAttrMapping.userUsernameAttr};
                SearchControls constraints = new SearchControls();
                constraints.setReturningAttributes(returnedAtts);
                constraints.setSearchScope(2);
                results = ctx.search(this.searchBase, this.filter, constraints);
                this.size = 0;
                while (results.hasMoreElements()) {
                    results.next();
                    ++this.size;
                }
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size : " + this.size));
        }
        return this.size;
    }
}

