/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;

public class ObjectPropertyReference
extends EntityReference {
    public ObjectPropertyReference(EntityReference reference) {
        super(reference.getName(), reference.getType(), reference.getParent());
    }

    public ObjectPropertyReference(String propertyName, ObjectReference objectReference) {
        super(propertyName, EntityType.OBJECT_PROPERTY, objectReference);
    }

    public ObjectPropertyReference(String wiki, String space, String page, String objectName, String propertyName) {
        this(propertyName, new ObjectReference(wiki, space, page, objectName));
    }

    public void setType(EntityType type) {
        if (type != EntityType.OBJECT_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an object property reference");
        }
        super.setType(EntityType.OBJECT);
    }

    public void setParent(EntityReference parent) {
        if (parent == null || parent.getType() != EntityType.OBJECT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] for an object property " + "reference");
        }
        super.setParent(new ObjectReference(parent));
    }
}

