/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.DoctypeMaker;
import com.google.caja.util.Function;
import junit.framework.TestCase;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class DoctypeMakerTest
extends TestCase {
    public final void testSystemIdToNsUri() {
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/html4/strict.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/html4/loose.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/html4/frameset.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd"));
        DoctypeMakerTest.assertEquals((String)"http://www.w3.org/2000/svg", (String)DoctypeMaker.systemIdToNsUri("http://www.w3.org/Graphics/SVG/1.1/DTD/svg-framework.dtd"));
        DoctypeMakerTest.assertEquals(null, (String)DoctypeMaker.systemIdToNsUri("http://bobs-house-of-doctypes/ONE/WELL/DONE/DTD/coming-up.dtd"));
    }

    public final void testIsHtml() {
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01 Transitional//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01 Frameset//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Strict//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Transitional//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Frameset//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd"));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//W3C//DTD HTML 3.2 Final//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("p", "-//IETF//DTD HTML//EN", null));
        DoctypeMakerTest.assertTrue((boolean)DoctypeMaker.isHtml("html", null, null));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("svg", "-//W3C//ENTITIES SVG 1.1 Modular Framework//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg-framework.dtd"));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("svg", null, "http://www.w3.org/Graphics/SVG/1.1/DTD/svg-framework.dtd"));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("svg", "-//W3C//ENTITIES SVG 1.1 Modular Framework//EN", null));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("svg", null, null));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("html", "-//W3C//ENTITIES SVG 1.1 Modular Framework//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg-framework.dtd"));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("html", null, "http://www.w3.org/Graphics/SVG/1.1/DTD/svg-framework.dtd"));
        DoctypeMakerTest.assertFalse((boolean)DoctypeMaker.isHtml("html", "-//W3C//ENTITIES SVG 1.1 Modular Framework//EN", null));
    }

    public final void testParse() throws Exception {
        this.assertDoctype("html", "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD HTML 4.01 Transitional//EN", null, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.assertDoctype("html", "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD HTML 3.2 Final//EN", null, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        this.assertDoctype("html", "-//IETF//DTD HTML//EN", null, "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
        this.assertDoctype("html", null, null, "<!DOCTYPE HTML>");
        this.assertDoctype("html", null, null, "<!DOCTYPE html>");
        this.assertDoctype("html", "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">");
        this.assertDoctype("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
    }

    private void assertDoctype(String name, String pubid, String systemId, String text) throws Exception {
        Function<DOMImplementation, DocumentType> maker = DoctypeMaker.parse(text);
        if (name == null) {
            DoctypeMakerTest.assertNull((String)text, maker);
            return;
        }
        DoctypeMakerTest.assertNotNull((String)text, maker);
        DOMImplementation impl = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 1.0 Traversal");
        DocumentType doctype = maker.apply(impl);
        DoctypeMakerTest.assertEquals((String)text, (String)name, (String)doctype.getName());
        DoctypeMakerTest.assertEquals((String)text, (String)systemId, (String)doctype.getSystemId());
        DoctypeMakerTest.assertEquals((String)text, (String)pubid, (String)doctype.getPublicId());
    }
}

