/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.bbcode.core;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.ks.bbcode.api.BBCode;
import org.exoplatform.ks.bbcode.api.BBCodeService;
import org.exoplatform.ks.bbcode.spi.BBCodeData;
import org.exoplatform.ks.bbcode.spi.BBCodePlugin;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="bbcode")})
@ManagedDescription(value="BBCodes management")
public class BBCodeServiceImpl
implements Startable,
BBCodeService,
ManagementAware {
    public static final String BBCODE_NODE_TYPE = "exo:forumBBCode".intern();
    public static final String BBCODE_HOME_NODE_TYPE = "exo:forumBBCodeHome".intern();
    private List<BBCodePlugin> plugins;
    private KSDataLocation dataLocator;
    private SessionManager sessionManager;
    private List<String> activeBBCodesCache = new ArrayList<String>();
    private ManagementContext context;
    private static Log log = ExoLogger.getLogger(BBCodeServiceImpl.class);

    public BBCodeServiceImpl() {
        this.plugins = new ArrayList<BBCodePlugin>();
    }

    public BBCodeServiceImpl(KSDataLocation dataLocator) {
        this();
        this.setDataLocator(dataLocator);
    }

    private Node getBBcodeHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getBBCodesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    @Override
    public void registerBBCodePlugin(BBCodePlugin plugin) throws Exception {
        this.plugins.add(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultBBCodes() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            NodeIterator iter = bbCodeHome.getNodes();
            if (iter.getSize() <= 0L) {
                ArrayList<BBCode> bbCodes = new ArrayList<BBCode>();
                for (BBCodePlugin pln : this.plugins) {
                    List<BBCodeData> codeDatas = pln.getBBCodeData();
                    for (BBCodeData codeData : codeDatas) {
                        BBCode bbCode = new BBCode();
                        bbCode.setTagName(codeData.getTagName());
                        bbCode.setReplacement(codeData.getReplacement());
                        bbCode.setDescription(codeData.getDescription());
                        bbCode.setExample(codeData.getExample());
                        bbCode.setOption(Boolean.parseBoolean(codeData.getIsOption()));
                        bbCode.setActive(Boolean.parseBoolean(codeData.getIsActive()));
                        bbCodes.add(bbCode);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Registered " + bbCode));
                    }
                    this.managePlugin(pln);
                }
                if (!bbCodes.isEmpty()) {
                    this.save(bbCodes);
                }
            }
        }
        finally {
            sProvider.close();
        }
    }

    private void managePlugin(BBCodePlugin pln) {
        try {
            if (this.context != null) {
                this.context.register((Object)pln);
            } else {
                log.warn((Object)("No Management context is available for " + this.getClass()));
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to register BBCode plugin " + pln.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(List<BBCode> bbcodes) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            for (BBCode bbcode : bbcodes) {
                Node bbcNode = this.createNode(bbCodeHome, bbcode);
                bbcNode.setProperty("exo:tagName", bbcode.getTagName());
                bbcNode.setProperty("exo:replacement", bbcode.getReplacement());
                bbcNode.setProperty("exo:example", bbcode.getExample());
                bbcNode.setProperty("exo:description", bbcode.getDescription());
                bbcNode.setProperty("exo:isActive", bbcode.isActive());
                bbcNode.setProperty("exo:isOption", bbcode.isOption());
            }
            if (bbCodeHome.isNew()) {
                bbCodeHome.getSession().save();
            } else {
                bbCodeHome.save();
            }
            List<String> list = this.activeBBCodesCache;
            synchronized (list) {
                this.activeBBCodesCache.clear();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving BBCodes", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private Node createNode(Node bbCodeHome, BBCode bbcode) throws Exception {
        Node bbcNode;
        String name = this.getNodeName(bbcode);
        try {
            bbcNode = bbCodeHome.getNode(bbcode.getId());
            if (!name.equals(bbcode.getId())) {
                bbcNode.remove();
                bbcNode = bbCodeHome.addNode(name, BBCODE_NODE_TYPE);
            }
        }
        catch (Exception e) {
            bbcNode = bbCodeHome.addNode(name, BBCODE_NODE_TYPE);
        }
        return bbcNode;
    }

    private String getNodeName(BBCode bbcode) {
        String id = bbcode.getTagName() + (bbcode.isOption() ? "=" : "");
        return id;
    }

    private BBCode nodeToBBCode(Node bbcNode) throws Exception {
        BBCode bbCode = new BBCode();
        bbCode.setId(bbcNode.getName());
        bbCode.setTagName(bbcNode.getProperty("exo:tagName").getString());
        bbCode.setReplacement(bbcNode.getProperty("exo:replacement").getString());
        bbCode.setExample(bbcNode.getProperty("exo:example").getString());
        if (bbcNode.hasProperty("exo:description")) {
            bbCode.setDescription(bbcNode.getProperty("exo:description").getString());
        }
        bbCode.setActive(bbcNode.getProperty("exo:isActive").getBoolean());
        bbCode.setOption(bbcNode.getProperty("exo:isOption").getBoolean());
        return bbCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BBCode> getAll() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            NodeIterator iter = bbCodeHome.getNodes();
            while (iter.hasNext()) {
                try {
                    Node bbcNode = iter.nextNode();
                    bbcodes.add(this.nodeToBBCode(bbcNode));
                }
                catch (Exception e) {
                    log.error((Object)"Error loading BBCodes", (Throwable)e);
                }
            }
        }
        finally {
            sProvider.close();
        }
        return bbcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getActive() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (this.activeBBCodesCache.isEmpty()) {
            try {
                Node bbCodeHome = this.getBBcodeHome(sProvider);
                if (bbCodeHome == null) {
                    List<String> list = this.activeBBCodesCache;
                    return list;
                }
                QueryManager qm = bbCodeHome.getSession().getWorkspace().getQueryManager();
                StringBuilder pathQuery = new StringBuilder();
                pathQuery.append("/jcr:root").append(bbCodeHome.getPath()).append("/element(*,").append(BBCODE_NODE_TYPE).append(")[@exo:isActive='true']");
                Query query = qm.createQuery(pathQuery.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                String tagName = "";
                List<String> list = this.activeBBCodesCache;
                synchronized (list) {
                    while (iter.hasNext()) {
                        Node bbcNode = iter.nextNode();
                        tagName = bbcNode.getName();
                        this.activeBBCodesCache.add(tagName);
                    }
                }
            }
            finally {
                sProvider.close();
            }
        }
        return this.activeBBCodesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BBCode findById(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        BBCode bbCode = new BBCode();
        try {
            Node bbCodeHome = this.getBBcodeHome(sProvider);
            try {
                Node bbcNode = bbCodeHome.getNode(id);
                bbCode = this.nodeToBBCode(bbcNode);
            }
            catch (Exception e) {
                log.error((Object)("Error loading BBCode" + id), (Throwable)e);
            }
        }
        finally {
            sProvider.close();
        }
        return bbCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String bbcodeId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Node bbCodeHome = this.getBBcodeHome(sProvider);
        try {
            bbCodeHome.getNode(bbcodeId).remove();
            bbCodeHome.save();
            List<String> list = this.activeBBCodesCache;
            synchronized (list) {
                this.activeBBCodesCache.clear();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error removing BBCode" + bbcodeId), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    public void start() {
        try {
            this.initDefaultBBCodes();
        }
        catch (Exception e) {
            log.error((Object)"Default BBCodes failed to initialize", (Throwable)e);
        }
    }

    public void stop() {
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    public KSDataLocation getDataLocator() {
        return this.dataLocator;
    }

    public void setDataLocator(KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
    }

    public List<BBCodePlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<BBCodePlugin> plugins) {
        this.plugins = plugins;
    }
}

