/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.service.gatein;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.ide.service.gatein.DeployGadgetException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.uri.UriComponent;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/ide/gadget")
public class RestGadgetRegistryService
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"ide.RestGadgetRegistryService");
    public static final String GADGET_MIME_TYPE = "application/x-google-gadget";
    private static final String DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String DEFAULT_MODULE_ID = "0";
    private static final String DEFAULT_GADGET_HOST = "eXoGadgetServer/gadgets";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/deploy")
    public Response addGadget(@Context UriInfo uriInfo, @QueryParam(value="gadgetURL") String gadgetUrl, @QueryParam(value="publicContext") String publicContext, @QueryParam(value="privateContext") String privateContext) {
        String urlEncoded = UriComponent.encode((String)gadgetUrl, (int)5, (boolean)false);
        String publicContextEncoded = UriComponent.encode((String)publicContext, (int)5, (boolean)false);
        String privateContextEncoded = UriComponent.encode((String)privateContext, (int)5, (boolean)false);
        urlEncoded = urlEncoded.replace(privateContextEncoded, publicContextEncoded);
        this.log.info((Object)("DEPLOY GADGET: " + urlEncoded));
        String name = "gadget" + urlEncoded.hashCode();
        try {
            Gadget gadget = this.createGadget(name, urlEncoded, false, uriInfo);
            if (gadget == null) {
                throw new WebApplicationException((Throwable)new DeployGadgetException("Gadget not deployed. Possible reason GadgetRegistryService not found"), 404);
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            RequestLifeCycle.begin((ExoContainer)container, (boolean)true);
            try {
                GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
                gadgetService.saveGadget(gadget);
                Response response = Response.ok().build();
                return response;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 500));
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 400));
        }
        catch (DeployGadgetException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 400));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/undeploy")
    public Response removeGadget(@QueryParam(value="gadgetURL") String gadgetUrl, @QueryParam(value="publicContext") String publicContext, @QueryParam(value="privateContext") String privateContext) {
        Response response;
        String urlEncoded = UriComponent.encode((String)gadgetUrl, (int)5, (boolean)false);
        String publicContextEncoded = UriComponent.encode((String)publicContext, (int)5, (boolean)false);
        String privateContextEncoded = UriComponent.encode((String)privateContext, (int)5, (boolean)false);
        urlEncoded = urlEncoded.replace(privateContextEncoded, publicContextEncoded);
        this.log.info((Object)("UNDEPLOY GADGET: " + urlEncoded));
        String name = "gadget" + urlEncoded.hashCode();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)container, (boolean)true);
        try {
            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
            if (gadgetService == null) {
                throw new WebApplicationException((Throwable)new DeployGadgetException("Can not undeployed. Possible reason GadgetRegistryService not found"), 404);
            }
            gadgetService.removeGadget(name);
            response = Response.noContent().build();
        }
        catch (Throwable throwable) {
            try {
                RequestLifeCycle.end();
                throw throwable;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), e.getCause());
                throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
            }
        }
        RequestLifeCycle.end();
        return response;
    }

    private Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }

    private Gadget createGadget(String name, String path, boolean isLocal, UriInfo uriInfo) throws JSONException, DeployGadgetException {
        Gadget gadget = new Gadget();
        gadget.setName(name);
        gadget.setUrl(path);
        gadget.setLocal(Boolean.valueOf(isLocal));
        Map<String, String> metaData = this.getMapMetadata(path, uriInfo);
        if (metaData == null) {
            return null;
        }
        if (metaData.containsKey("errors")) {
            throw new DeployGadgetException("error on the server: " + metaData.get("errors"));
        }
        String title = metaData.get("directoryTitle");
        if (title == null || title.trim().length() < 1) {
            title = metaData.get("title");
        }
        if (title == null || title.trim().length() < 1) {
            title = gadget.getName();
        }
        gadget.setTitle(title);
        gadget.setDescription(metaData.get("description"));
        gadget.setReferenceUrl(metaData.get("titleUrl"));
        gadget.setThumbnail(metaData.get("thumbnail"));
        return gadget;
    }

    private Map<String, String> getMapMetadata(String url, UriInfo uriInfo) throws JSONException {
        HashMap<String, String> mapMetaData = new HashMap<String, String>();
        String metadata = this.fetchGagdetMetadata(url, uriInfo);
        if (metadata == null) {
            return null;
        }
        metadata = metadata.substring(metadata.indexOf("[") + 1, metadata.lastIndexOf("]"));
        JSONObject jsonObj = new JSONObject(metadata);
        Iterator iter = jsonObj.keys();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            mapMetaData.put(element, jsonObj.get(element).toString());
        }
        return mapMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchGagdetMetadata(String urlStr, UriInfo uriInfo) {
        String result = null;
        String country = DEFAULT_COUNTRY;
        String language = DEFAULT_LANGUAGE;
        String moduleId = DEFAULT_MODULE_ID;
        String gadgetHost = DEFAULT_GADGET_HOST;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)container, (boolean)true);
        try {
            GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
            if (gadgetService == null) {
                String string = null;
                return string;
            }
            country = gadgetService.getCountry();
            language = gadgetService.getLanguage();
            moduleId = gadgetService.getModuleId();
            gadgetHost = gadgetService.getHostName();
        }
        finally {
            RequestLifeCycle.end();
        }
        try {
            String data = "{\"context\":{\"country\":\"" + country + "\",\"language\":\"" + language + "\"},\"gadgets\":[" + "{\"moduleId\":" + moduleId + ",\"url\":\"" + urlStr + "\",\"prefs\":[]}]}";
            String metadataPath = gadgetHost + (gadgetHost.endsWith("/") ? "" : "/") + "metadata";
            URL url = null;
            if (!gadgetHost.startsWith("http")) {
                int port;
                if (!metadataPath.startsWith("/")) {
                    metadataPath = "/" + metadataPath;
                }
                url = -1 != (port = uriInfo.getRequestUri().getPort()) ? new URL(uriInfo.getRequestUri().getScheme(), uriInfo.getRequestUri().getHost(), port, metadataPath) : new URL(uriInfo.getRequestUri().getScheme(), uriInfo.getRequestUri().getHost(), metadataPath);
            } else {
                url = new URL(metadataPath);
            }
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            result = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
        }
        catch (IOException ioexc) {
            return "{}";
        }
        return result;
    }
}

