/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpgradeProductPlugin
extends BaseComponentPlugin
implements Comparable<UpgradeProductPlugin> {
    private static final String PRODUCT_GROUP_ID = "product.group.id";
    private static final String UPGRADE_PLUGIN_EXECUTION_ORDER = "plugin.execution.order";
    private static final String UPGRADE_PLUGIN_ENABLE = "commons.upgrade.{$0}.enable";
    private int pluginExecutionOrder;
    protected String productGroupId;

    public UpgradeProductPlugin(InitParams initParams) {
        if (!initParams.containsKey((Object)PRODUCT_GROUP_ID)) {
            throw new RuntimeException("Couldn't find the init value param: product.group.id");
        }
        this.productGroupId = initParams.getValueParam(PRODUCT_GROUP_ID).getValue();
        this.pluginExecutionOrder = !initParams.containsKey((Object)UPGRADE_PLUGIN_EXECUTION_ORDER) ? 0 : Integer.parseInt(initParams.getValueParam(UPGRADE_PLUGIN_EXECUTION_ORDER).getValue());
    }

    public String getProductGroupId() {
        return this.productGroupId;
    }

    public boolean isEnabled() {
        String isEnabledProperty = PropertyManager.getProperty((String)UPGRADE_PLUGIN_ENABLE.replace("{$0}", this.getName()));
        return isEnabledProperty == null || isEnabledProperty.equals("true");
    }

    public void addNodeVersion(Node nodeToAddVersion, String versionLabel) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, ItemExistsException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        if (!nodeToAddVersion.isNodeType("mix:versionable")) {
            nodeToAddVersion.addMixin("mix:versionable");
            nodeToAddVersion.save();
            nodeToAddVersion.getSession().save();
            nodeToAddVersion.getSession().refresh(true);
        }
        if (nodeToAddVersion.isCheckedOut()) {
            Version version = nodeToAddVersion.checkin();
            nodeToAddVersion.getVersionHistory().addVersionLabel(version.getName(), versionLabel, false);
        }
        nodeToAddVersion.checkout();
    }

    public abstract void processUpgrade(String var1, String var2);

    public abstract boolean shouldProceedToUpgrade(String var1, String var2);

    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof UpgradeProductPlugin) {
            return this.getName().equals(((UpgradeProductPlugin)obj).getName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(UpgradeProductPlugin o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getPluginExecutionOrder() == o.getPluginExecutionOrder()) {
            return -1;
        }
        return this.getPluginExecutionOrder() - o.getPluginExecutionOrder();
    }

    public int getPluginExecutionOrder() {
        return this.pluginExecutionOrder;
    }
}

