/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanHelper;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCleaner {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBClean");
    protected final Connection connection;
    protected final List<String> cleanScripts = new ArrayList<String>();
    protected final List<String> rollbackScripts = new ArrayList<String>();
    protected final List<String> commitScripts = new ArrayList<String>();
    protected final DBCleanHelper dbCleanHelper;
    protected final boolean autoCommit;

    public DBCleaner(Connection connection, List<String> cleanScripts, List<String> rollbackScripts, List<String> commitScripts, DBCleanHelper dbCleanHelper, boolean autoCommit) {
        this.connection = connection;
        this.cleanScripts.addAll(cleanScripts);
        this.rollbackScripts.addAll(rollbackScripts);
        this.commitScripts.addAll(commitScripts);
        this.dbCleanHelper = dbCleanHelper;
        this.autoCommit = autoCommit;
    }

    public DBCleaner(Connection connection, List<String> cleanScripts, List<String> rollbackScripts, List<String> commitScripts, boolean autoCommit) {
        this(connection, cleanScripts, rollbackScripts, commitScripts, null, autoCommit);
    }

    public void executeCleanScripts() throws SQLException {
        this.executeScripts(this.cleanScripts);
        if (this.dbCleanHelper != null) {
            this.dbCleanHelper.executeCleanScripts();
        }
    }

    public void executeRollbackScripts() throws SQLException {
        this.executeScripts(this.rollbackScripts);
    }

    public void executeCommitScripts() throws SQLException {
        this.executeScripts(this.commitScripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScripts(List<String> scripts) throws SQLException {
        boolean autoCommit;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        if (this.autoCommit != (autoCommit = this.connection.getAutoCommit())) {
            this.connection.setAutoCommit(this.autoCommit);
        }
        Statement st = this.connection.createStatement();
        try {
            for (String scr : scripts) {
                String sql = DBInitializerHelper.cleanWhitespaces(scr.trim());
                if (sql.length() <= 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.executeQuery(st, sql);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the Statement." + e));
            }
            if (this.autoCommit != autoCommit) {
                this.connection.setAutoCommit(autoCommit);
            }
            throw throwable;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement." + e));
        }
        if (this.autoCommit != autoCommit) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    protected void executeQuery(final Statement statement, final String sql) throws SQLException {
        SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                statement.executeUpdate(sql);
                return null;
            }
        });
    }
}

