/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RemoveAttachmentActionComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiAttachmentUploadListForm.gtmpl")
public class UIWikiAttachmentUploadListForm
extends UIForm {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.wiki.webui.control.UIAttachmentUploadContainer");
    public static final String DOWNLOAD_ACTION = "DownloadAttachment";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiAttachmentUploadListForm";

    public UIWikiAttachmentUploadListForm() throws Exception {
        this.addChild(RemoveAttachmentActionComponent.class, null, null);
    }

    protected Collection<AttachmentImpl> getAttachmentsList() {
        Collection<Object> attachments = new ArrayList<AttachmentImpl>();
        try {
            Page page = this.getCurrentWikiPage();
            if (page != null) {
                attachments = ((PageImpl)page).getAttachmentsExcludeContent();
            }
        }
        catch (Exception e) {
            log.warn((Object)"An error happened when get attachments list", (Throwable)e);
        }
        return attachments;
    }

    protected String getFullName(String userId) {
        String fullName = "";
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userId);
            fullName = user.getFullName();
        }
        catch (Exception e) {
            log.warn((Object)("An error happened when get fullname for: " + userId), (Throwable)e);
        }
        return fullName;
    }

    public Page getCurrentWikiPage() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
            return Utils.getCurrentNewDraftWikiPage();
        }
        return Utils.getCurrentWikiPage();
    }

    protected void renderActions(String attName) throws Exception {
        if (attName == null) {
            return;
        }
        RemoveAttachmentActionComponent component = (RemoveAttachmentActionComponent)this.getChild(RemoveAttachmentActionComponent.class);
        component.setAttachmentName(attName);
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        PageImpl page = (PageImpl)this.getCurrentWikiPage();
        AttachmentImpl attachment = page.getAttachment(attName);
        HashMap<String, AttachmentImpl> context = new HashMap<String, AttachmentImpl>();
        context.put("attachmentName", attachment);
        if (manager.accept(EXTENSION_TYPE, "RemoveAttachment", context)) {
            this.renderChild(RemoveAttachmentActionComponent.class);
        }
    }
}

