/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiDeletePageConfirm.gtmpl", events={@EventConfig(listeners={OKActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiDeletePageConfirm
extends UIWikiComponent {
    private WikiService wservice;
    private String pageID;
    private String owner;

    public UIWikiDeletePageConfirm() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.DELETEPAGE);
        this.wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
    }

    protected List<SearchResult> getRelativePages() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            return this.wservice.searchRenamedPage(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PageImpl getCurrentPage() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            this.pageID = params.getPageId();
            this.owner = params.getOwner();
            return (PageImpl)this.wservice.getPageById(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getCurrentPageId() {
        return this.pageID;
    }

    protected String getWiki() {
        return this.owner;
    }

    protected String getHomeURL() {
        return Util.getPortalRequestContext().getPortalURI() + "wiki";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWikiDeletePageConfirm> {
        public void execute(Event<UIWikiDeletePageConfirm> event) throws Exception {
            UIWikiDeletePageConfirm component = (UIWikiDeletePageConfirm)((Object)event.getSource());
            ((UIWikiPortlet)component.getAncestorOfType(UIWikiPortlet.class)).changeMode(WikiMode.VIEW);
            PortalRequestContext prContext = Util.getPortalRequestContext();
            prContext.setResponseComplete(true);
            prContext.getResponse().sendRedirect(Utils.getCurrentRequestURL());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OKActionListener
    extends EventListener<UIWikiDeletePageConfirm> {
        public void execute(Event<UIWikiDeletePageConfirm> event) throws Exception {
            UIWikiDeletePageConfirm component = (UIWikiDeletePageConfirm)((Object)event.getSource());
            WikiService wService = (WikiService)PortalContainer.getComponent(WikiService.class);
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            wService.deletePage(params.getType(), params.getOwner(), params.getPageId());
            ((UIWikiPortlet)component.getAncestorOfType(UIWikiPortlet.class)).changeMode(WikiMode.VIEW);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiDeletePageConfirm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiBreadCrumb breadcumb = (UIWikiBreadCrumb)wikiPortlet.findFirstComponentOfType(UIWikiBreadCrumb.class);
            PortalRequestContext prContext = Util.getPortalRequestContext();
            String parentURL = breadcumb.getParentURL();
            prContext.setResponseComplete(true);
            prContext.getResponse().sendRedirect(parentURL);
        }
    }
}

