/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIAttachmentContainer;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageInfoArea.gtmpl", events={@EventConfig(listeners={CompareRevisionActionListener.class}), @EventConfig(listeners={ShowRevisionActionListener.class}), @EventConfig(listeners={ToggleAttachmentsActionListener.class})})
public class UIWikiPageInfoArea
extends UIWikiContainer {
    private static final Log log = ExoLogger.getLogger((String)"wiki:UIWikiPageInfoArea");
    public static String TOGGLE_ATTACHMENTS_ACTION = "ToggleAttachments";
    public static String SHOW_REVISION = "ShowRevision";
    public static String COMPARE_REVISION = "CompareRevision";

    public UIWikiPageInfoArea() {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW);
    }

    protected PageImpl getCurrentWikiPage() {
        PageImpl currentPage = null;
        try {
            currentPage = (PageImpl)Utils.getCurrentWikiPage();
        }
        catch (Exception e) {
            log.warn((Object)"An error happened when getting current wiki page", (Throwable)e);
        }
        return currentPage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareRevisionActionListener
    extends org.exoplatform.wiki.webui.control.action.CompareRevisionActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            ArrayList<NTVersion> lstVersion = new ArrayList<NTVersion>(Utils.getCurrentPageRevisions());
            this.setVersionToCompare(lstVersion);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            String verName = pageParams.getParameter("verName");
            if (!StringUtils.isEmpty((String)verName)) {
                for (int i = 0; i < lstVersion.size(); ++i) {
                    NTVersion ver = lstVersion.get(i);
                    if (!ver.getName().equals(verName) || i >= lstVersion.size() + 1) continue;
                    this.setFrom(i);
                    this.setTo(i + 1);
                    break;
                }
            }
            super.execute(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowRevisionActionListener
    extends EventListener<UIWikiPageInfoArea> {
        public void execute(Event<UIWikiPageInfoArea> event) throws Exception {
            UIWikiPageInfoArea infoArea = (UIWikiPageInfoArea)((Object)event.getSource());
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)infoArea.getParent();
            UIWikiPageVersionsList pageVersions = (UIWikiPageVersionsList)bottomArea.getChild(UIWikiPageVersionsList.class);
            if (pageVersions.isRendered()) {
                pageVersions.setRendered(false);
            } else {
                UIAttachmentContainer attachform = (UIAttachmentContainer)bottomArea.getChild(UIAttachmentContainer.class);
                if (attachform.isRendered()) {
                    attachform.setRendered(false);
                }
                pageVersions.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(bottomArea.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleAttachmentsActionListener
    extends EventListener<UIWikiPageInfoArea> {
        public void execute(Event<UIWikiPageInfoArea> event) throws Exception {
            UIWikiBottomArea wikiBottomArea = (UIWikiBottomArea)((UIWikiPageInfoArea)((Object)event.getSource())).getAncestorOfType(UIWikiBottomArea.class);
            UIAttachmentContainer attachform = (UIAttachmentContainer)wikiBottomArea.findFirstComponentOfType(UIAttachmentContainer.class);
            if (attachform.isRendered()) {
                attachform.setRendered(false);
            } else {
                attachform.setRendered(true);
                UIWikiPageVersionsList pageVersions = (UIWikiPageVersionsList)wikiBottomArea.findFirstComponentOfType(UIWikiPageVersionsList.class);
                if (pageVersions.isRendered()) {
                    pageVersions.setRendered(false);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(wikiBottomArea.getParent());
        }
    }
}

