/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.control.UIWikiExtensionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/UIRelatedPagesContainer.gtmpl")
public class UIRelatedPagesContainer
extends UIWikiExtensionContainer {
    private static final Log log = ExoLogger.getLogger(UIRelatedPagesContainer.class);
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.control.UIRelatedPagesContainer";
    private UIWikiBreadCrumb breadcrumb = (UIWikiBreadCrumb)this.addChild(UIWikiBreadCrumb.class, null, "UIWikiBreadCrumb_PageInfo");

    public UIRelatedPagesContainer() throws Exception {
        this.breadcrumb.setLink(false);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    protected boolean isHasExtension() {
        return this.extensionSize > 0;
    }

    @Override
    public String getExtensionType() {
        return EXTENSION_TYPE;
    }

    public List<BreadcrumbData> getBreadcrumbDatas(Page page) {
        WikiService service = (WikiService)this.getApplicationComponent(WikiService.class);
        WikiPageParams params = org.exoplatform.wiki.utils.Utils.getWikiPageParams((Page)page);
        try {
            return service.getBreadcumb(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("can not load BreadcrumbData for page [%s]", page.getName()), (Throwable)e);
            }
            return new ArrayList<BreadcrumbData>();
        }
    }

    protected Page getCurrentPage() throws Exception {
        return Utils.getCurrentWikiPage();
    }
}

