/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.AdminPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.MoreContainerActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={PagePermissionActionListener.class})})
public class PagePermissionActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "PagePermission";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new AdminPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PagePermissionActionListener
    extends MoreContainerActionListener<PagePermissionActionComponent> {
        @Override
        protected void processEvent(Event<PagePermissionActionComponent> event) throws Exception {
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((PagePermissionActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer uiPopupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            UIWikiPermissionForm uiWikiPermissionForm = (UIWikiPermissionForm)uiPopupContainer.createUIComponent(UIWikiPermissionForm.class, null, "UIWikiPagePermissionForm");
            uiPopupContainer.activate((UIComponent)uiWikiPermissionForm, 800, 0);
            uiWikiPermissionForm.setScope(UIWikiPermissionForm.Scope.PAGE);
            PageImpl page = (PageImpl)Utils.getCurrentWikiPage();
            HashMap permissionMap = page.getPermission();
            HashMap adminsACLMap = org.exoplatform.wiki.utils.Utils.getACLForAdmins();
            for (String id : adminsACLMap.keySet()) {
                permissionMap.remove(id);
            }
            List<PermissionEntry> permissionEntries = this.convertToPermissionEntryList(permissionMap);
            uiWikiPermissionForm.setPermission(permissionEntries);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            super.processEvent(event);
        }

        private List<PermissionEntry> convertToPermissionEntryList(HashMap<String, String[]> permissions) {
            ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
            Set<Map.Entry<String, String[]>> entries = permissions.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                PermissionEntry permissionEntry = new PermissionEntry();
                String key = entry.getKey();
                IDType idType = IDType.USER;
                if (key.indexOf(":") > 0) {
                    idType = IDType.MEMBERSHIP;
                } else if (key.indexOf("/") > 0) {
                    idType = IDType.GROUP;
                }
                permissionEntry.setIdType(idType);
                permissionEntry.setId(key);
                Permission[] perms = new Permission[2];
                perms[0] = new Permission();
                perms[0].setPermissionType(PermissionType.VIEWPAGE);
                perms[1] = new Permission();
                perms[1].setPermissionType(PermissionType.EDITPAGE);
                for (String action : entry.getValue()) {
                    if ("read".equals(action)) {
                        perms[0].setAllowed(true);
                        continue;
                    }
                    if (!"add_node".equals(action) && !"remove".equals(action) && !"set_property".equals(action)) continue;
                    perms[1].setAllowed(true);
                }
                permissionEntry.setPermissions(perms);
                permissionEntries.add(permissionEntry);
            }
            return permissionEntries;
        }
    }
}

