/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.control.action.core.AbstractFormActionComponent;
import org.exoplatform.wiki.webui.control.filter.IsEditAddModeFilter;
import org.exoplatform.wiki.webui.control.listener.UIEditorTabsActionListener;
import org.exoplatform.wiki.webui.popup.UIWikiPagePreview;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={PreviewPageActionListener.class}, phase=Event.Phase.DECODE)})
public class PreviewPageActionComponent
extends AbstractFormActionComponent {
    public static final String ACTION = "PreviewPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return false;
    }

    @Override
    public boolean isSubmit() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewPageActionListener
    extends UIEditorTabsActionListener<PreviewPageActionComponent> {
        @Override
        protected void processEvent(Event<PreviewPageActionComponent> event) throws Exception {
            String markup;
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((PreviewPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            UIWikiMaskWorkspace uiMaskWS = (UIWikiMaskWorkspace)wikiPortlet.getChild(UIWikiMaskWorkspace.class);
            UIWikiPageEditForm wikiPageEditForm = (UIWikiPageEditForm)((PreviewPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPageEditForm.class);
            UIWikiPagePreview wikiPagePreview = (UIWikiPagePreview)uiMaskWS.createUIComponent(UIWikiPagePreview.class, null, null);
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)wikiPageEditForm.getChild(UIWikiRichTextArea.class);
            UIWikiPageTitleControlArea wikiPageTitleArea = (UIWikiPageTitleControlArea)wikiPageEditForm.getChild(UIWikiPageTitleControlArea.class);
            String markupSyntax = (String)wikiPageEditForm.getUIFormSelectBox("SyntaxType").getValue();
            boolean isRichTextRendered = wikiRichTextArea.isRendered();
            RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
            if (isRichTextRendered) {
                String htmlContent = (String)wikiRichTextArea.getUIFormTextAreaInput().getValue();
                markup = renderingService.render(htmlContent, Syntax.XHTML_1_0.toIdString(), markupSyntax, false);
                Utils.feedDataForWYSIWYGEditor(wikiPageEditForm, markup);
            } else {
                UIFormTextAreaInput markupInput = (UIFormTextAreaInput)wikiPageEditForm.findComponentById("Markup");
                markup = markupInput.getValue() == null ? "" : (String)markupInput.getValue();
            }
            wikiPagePreview.renderWikiMarkup(markup, markupSyntax);
            String pageTitle = wikiPageTitleArea.getTitle();
            if (pageTitle != null) {
                wikiPagePreview.setPageTitle(wikiPageTitleArea.getTitle());
            } else {
                wikiPagePreview.setPageTitle(res.getString("UIWikiPageTitleControlArea.label.Untitled"));
            }
            uiMaskWS.setUIComponent((UIComponent)wikiPagePreview);
            uiMaskWS.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            super.processEvent(event);
        }
    }
}

