/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.WikiNameValidator;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.IsEditAddModeFilter;
import org.exoplatform.wiki.webui.control.filter.IsEditAddPageModeFilter;
import org.exoplatform.wiki.webui.control.listener.UISubmitToolBarActionListener;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/action/SavePageActionComponent.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, phase=Event.Phase.DECODE)})
public class SavePageActionComponent
extends UIComponent {
    public static final String ACTION = "SavePage";
    private static final Log log = ExoLogger.getLogger((String)"wiki:SavePageActionComponent");
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddModeFilter(), new IsEditAddPageModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    protected boolean isNewMode() {
        return WikiMode.ADDPAGE.equals((Object)((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode());
    }

    protected String getPageTitleInputId() {
        return "TitleInput";
    }

    protected String getActionLink() throws Exception {
        return Utils.createFormActionLink(this, ACTION, ACTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavePageActionListener
    extends UISubmitToolBarActionListener<SavePageActionComponent> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event<SavePageActionComponent> event) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((SavePageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            UIWikiPageTitleControlArea pageTitleControlForm = (UIWikiPageTitleControlArea)wikiPortlet.findComponentById("UIWikiPageTitleControlForm_PageControlArea");
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            UIFormSelectBox syntaxTypeSelectBox = (UIFormSelectBox)pageEditForm.findComponentById("SyntaxType");
            RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
            Page page = Utils.getCurrentWikiPage();
            Utils.setUpWikiContext(wikiPortlet);
            try {
                WikiNameValidator.validate((String)((String)titleInput.getValue()));
            }
            catch (IllegalNameException ex) {
                String msg = ex.getMessage();
                ApplicationMessage appMsg = new ApplicationMessage("WikiPageNameValidator.msg.EmptyTitle", null, 1);
                if (msg != null) {
                    Object[] arg = new Object[]{msg};
                    appMsg = new ApplicationMessage("WikiPageNameValidator.msg.Invalid-char", arg, 1);
                }
                event.getRequestContext().getUIApplication().addMessage(appMsg);
                event.getRequestContext().setProcessRender(true);
            }
            if (event.getRequestContext().getProcessRender()) {
                Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                return;
            }
            String title = ((String)titleInput.getValue()).trim();
            if (wikiRichTextArea.isRendered()) {
                String htmlContent = (String)wikiRichTextArea.getUIFormTextAreaInput().getValue();
                String markupContent = renderingService.render(htmlContent, Syntax.XHTML_1_0.toIdString(), (String)syntaxTypeSelectBox.getValue(), false);
                markupInput.setValue((Object)markupContent);
            }
            String markup = markupInput.getValue() == null ? "" : (String)markupInput.getValue();
            markup = markup.trim();
            String syntaxId = (String)syntaxTypeSelectBox.getValue();
            String newPageId = TitleResolver.getId((String)title, (boolean)false);
            if (!("WikiHome".equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || newPageId.equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || !wikiService.isExisting(pageParams.getType(), pageParams.getOwner(), newPageId))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The title '" + title + "' is already existing!"));
                }
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("SavePageAction.msg.warning-page-title-already-exist", null, 1));
                Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                return;
            }
            try {
                if (wikiPortlet.getWikiMode() == WikiMode.EDITPAGE) {
                    Object minorAtt;
                    if (wikiPortlet.getEditMode() == EditMode.SECTION) {
                        newPageId = page.getName();
                        title = page.getTitle();
                        markup = renderingService.updateContentOfSection(page.getContent().getText(), page.getSyntax(), wikiPortlet.getSectionIndex(), markup);
                    }
                    if (!page.getName().equals(newPageId)) {
                        wikiService.renamePage(pageParams.getType(), pageParams.getOwner(), page.getName(), newPageId, title);
                    }
                    if ((minorAtt = event.getRequestContext().getAttribute("MinorEdit")) != null) {
                        ((PageImpl)page).setMinorEdit(Boolean.parseBoolean(minorAtt.toString()));
                    }
                    page.setComment((String)commentInput.getValue());
                    page.setSyntax(syntaxId);
                    pageTitleControlForm.getUIFormInputInfo().setValue((Object)title);
                    pageParams.setPageId(page.getName());
                    ((PageImpl)page).setURL(Utils.getURLFromParams(pageParams));
                    page.getContent().setText(markup);
                    if (!pageEditForm.getTitle().equals(title)) {
                        page.setTitle(title);
                        ((PageImpl)page).checkin();
                        ((PageImpl)page).checkout();
                        pageParams.setPageId(newPageId);
                    } else {
                        ((PageImpl)page).checkin();
                        ((PageImpl)page).checkout();
                    }
                } else if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
                    String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
                    Page draftPage = wikiService.getExsitedOrNewDraftPageById(null, null, sessionId);
                    Collection attachs = ((PageImpl)draftPage).getAttachments();
                    Page subPage = wikiService.createPage(pageParams.getType(), pageParams.getOwner(), title, page.getName());
                    pageParams.setPageId(newPageId);
                    ((PageImpl)subPage).setURL(Utils.getURLFromParams(pageParams));
                    subPage.getContent().setText(markup);
                    subPage.setSyntax(syntaxId);
                    ((PageImpl)subPage).getAttachments().addAll(attachs);
                    ((PageImpl)subPage).checkin();
                    ((PageImpl)subPage).checkout();
                    ((PageImpl)draftPage).remove();
                    return;
                }
            }
            catch (Exception e) {
                log.error((Object)("An exception happens when saving the page with title:" + title), (Throwable)e);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIPageToolBar.msg.Exception", null, 0));
            }
            finally {
                wikiPortlet.changeMode(WikiMode.VIEW);
                Utils.redirect(pageParams, WikiMode.VIEW);
                super.processEvent(event);
            }
        }
    }
}

