/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIAdvancePageIterator.gtmpl", events={@EventConfig(listeners={GoPageActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class})})
public class UIAdvancePageIterator
extends UIForm {
    public static String PREVIOUS = "previous".intern();
    public static String NEXT = "next".intern();
    public static String FIRST = "first".intern();
    public static String LAST = "last".intern();
    public static String GOPAGE = "GoPage".intern();
    public static String GOTOPPAGE = "goPageTop".intern();
    private PageList pageList;
    private int beginPageRange = 0;
    private int endPageRange = 0;

    public UIAdvancePageIterator() {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(GOTOPPAGE, null));
        this.setSubmitAction("return false;");
    }

    public void setPageList(PageList pageList) {
        this.pageList = pageList;
    }

    public PageList getPageList() {
        return this.pageList;
    }

    public List<String> getDisplayedRange() throws Exception {
        long page;
        int max_Page = this.pageList.getAvailablePage();
        if (this.pageList.getCurrentPage() > max_Page) {
            this.pageList.getPage(max_Page);
        }
        if ((page = (long)this.pageList.getCurrentPage()) <= 3L) {
            this.beginPageRange = 1;
            this.endPageRange = max_Page <= 7 ? max_Page : 7;
        } else if ((long)max_Page > page + 3L) {
            this.endPageRange = (int)(page + 3L);
            this.beginPageRange = (int)(page - 3L);
        } else {
            this.endPageRange = max_Page;
            this.beginPageRange = max_Page > 7 ? max_Page - 6 : 1;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = this.beginPageRange; i <= this.endPageRange; ++i) {
            temp.add(String.valueOf(i));
        }
        return temp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GoNumberPageActionListener
    extends EventListener<UIAdvancePageIterator> {
        public void execute(Event<UIAdvancePageIterator> event) throws Exception {
            UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)((Object)event.getSource());
            UIFormStringInput stringInput = pageIterator.getUIStringInput(GOTOPPAGE);
            String numberPage = "";
            numberPage = (String)stringInput.getValue();
            stringInput.setValue((Object)"");
            int maxPage = pageIterator.pageList.getAvailablePage();
            int presentPage = pageIterator.getPageList().getCurrentPage();
            int page = 0;
            if (numberPage != null && numberPage.length() > 0) {
                try {
                    page = Integer.parseInt(numberPage.trim());
                    if (page < 0) {
                        Object[] objectArray = new String[1];
                        objectArray[0] = pageIterator.getLabel(GOPAGE);
                        event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("NameValidator.msg.Invalid-number", objectArray, 1));
                    } else {
                        if (page == 0) {
                            page = 1;
                        } else if (page > pageIterator.pageList.getAvailablePage()) {
                            page = pageIterator.pageList.getAvailablePage();
                        }
                        pageIterator.getPageList().getPage(page);
                    }
                }
                catch (NumberFormatException e) {
                    Object[] objectArray = new String[1];
                    objectArray[0] = pageIterator.getLabel(GOPAGE);
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("NameValidator.msg.Invalid-number", objectArray, 1));
                }
            }
            if (page > 0 && page <= maxPage && page != presentPage) {
                pageIterator.getPageList().getPage(page);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(pageIterator.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GoPageActionListener
    extends EventListener<UIAdvancePageIterator> {
        public void execute(Event<UIAdvancePageIterator> event) throws Exception {
            UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)((Object)event.getSource());
            String changeToPage = event.getRequestContext().getRequestParameter("objectId").trim();
            int maxPage = pageIterator.pageList.getAvailablePage();
            int presentPage = pageIterator.getPageList().getCurrentPage();
            if (NEXT.equalsIgnoreCase(changeToPage)) {
                if (presentPage < maxPage) {
                    pageIterator.pageList.getPage(presentPage + 1);
                }
            } else if (PREVIOUS.equalsIgnoreCase(changeToPage)) {
                if (presentPage > 1) {
                    pageIterator.pageList.getPage(presentPage - 1);
                }
            } else if (LAST.equalsIgnoreCase(changeToPage)) {
                if (presentPage != maxPage) {
                    pageIterator.pageList.getPage(maxPage);
                }
            } else if (FIRST.equalsIgnoreCase(changeToPage)) {
                if (presentPage != 1) {
                    pageIterator.pageList.getPage(1);
                }
            } else {
                int temp = Integer.parseInt(changeToPage);
                if (temp > 0 && temp <= maxPage && temp != presentPage) {
                    pageIterator.pageList.getPage(temp);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(pageIterator.getParent());
        }
    }
}

