/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Preferences;
import org.exoplatform.wiki.mow.core.api.wiki.PreferencesSyntax;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSyntaxPreferences;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiEditPreferencesForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiEditPreferencesForm
extends UIForm
implements UIPopupComponent {
    public static final String PREFERENCES_SYNTAX = "PreferencesSyntax";

    public UIWikiEditPreferencesForm() throws Exception {
        this.addUIFormInput(new UIWikiSyntaxPreferences(PREFERENCES_SYNTAX));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWikiEditPreferencesForm> {
        public void execute(Event<UIWikiEditPreferencesForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiEditPreferencesForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWikiEditPreferencesForm> {
        public void execute(Event<UIWikiEditPreferencesForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiEditPreferencesForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiSyntaxPreferences uiSyntaxPreferences = (UIWikiSyntaxPreferences)wikiPortlet.findComponentById(UIWikiEditPreferencesForm.PREFERENCES_SYNTAX);
            UIFormSelectBox defaultSyntaxSelect = (UIFormSelectBox)uiSyntaxPreferences.getChildById("DefaultSyntax");
            UIFormCheckBoxInput allowCheckBox = (UIFormCheckBoxInput)uiSyntaxPreferences.getChildById("AllowChooseOthers");
            WikiImpl currentWiki = (WikiImpl)Utils.getCurrentWiki();
            Preferences preferences = currentWiki.getPreferences();
            PreferencesSyntax preferencesSyntax = preferences.getPreferencesSyntax();
            preferencesSyntax.setAllowMutipleSyntaxes(allowCheckBox.isChecked());
            preferencesSyntax.setDefaultSyntax((String)defaultSyntaxSelect.getValue());
            ((UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class)).reloadSyntax();
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.deActivate();
        }
    }
}

