/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiLocationContainer;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.tree.EventUIComponent;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiMovePageForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={MoveActionListener.class})})
public class UIWikiMovePageForm
extends UIForm
implements UIPopupComponent {
    public static final String PAGENAME_INFO = "pageNameInfo";
    public static final String LOCATION_CONTAINER = "UIWikiLocationContainer";
    public static final String UITREE = "UIMoveTree";
    public String MOVE = "Move";

    public UIWikiMovePageForm() throws Exception {
        this.addChild((UIComponent)new UIFormInputInfo(PAGENAME_INFO, PAGENAME_INFO, null));
        this.addChild(UIWikiLocationContainer.class, null, LOCATION_CONTAINER);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UITREE);
        EventUIComponent eventComponent = new EventUIComponent(LOCATION_CONTAINER, "ChangeNewLocation", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(), eventComponent);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private String getInitParam() throws Exception {
        StringBuilder sb = new StringBuilder();
        String currentPath = Utils.getCurrentWikiPagePath();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((UIWikiMovePageForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiMovePageForm movePageForm = (UIWikiMovePageForm)((Object)event.getSource());
            UIWikiLocationContainer locationContainer = (UIWikiLocationContainer)movePageForm.findFirstComponentOfType(UIWikiLocationContainer.class);
            UIWikiBreadCrumb currentLocation = (UIWikiBreadCrumb)locationContainer.getChildById("currentLocation");
            UIWikiBreadCrumb newLocation = (UIWikiBreadCrumb)locationContainer.getChildById("newLocation");
            WikiPageParams currentLocationParams = currentLocation.getPageParam();
            WikiPageParams newLocationParams = newLocation.getPageParam();
            if (newLocationParams == null) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.new-location-can-not-be-empty", null, 1));
                Utils.redirect(currentLocationParams, uiWikiPortlet.getWikiMode());
                return;
            }
            PageImpl movepage = (PageImpl)wservice.getPageById(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageId());
            PageImpl existPage = (PageImpl)wservice.getPageById(newLocationParams.getType(), newLocationParams.getOwner(), currentLocationParams.getPageId());
            if (existPage != null && !existPage.equals(movepage)) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiMovePageForm.msg.same-name-in-new-location-space", null, 1));
                Utils.redirect(currentLocationParams, uiWikiPortlet.getWikiMode());
                return;
            }
            wservice.movePage(currentLocationParams, newLocationParams);
            UIPopupContainer popupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            newLocationParams.setPageId(currentLocationParams.getPageId());
            Utils.redirect(newLocationParams, WikiMode.VIEW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIWikiMovePageForm> {
        public void execute(Event<UIWikiMovePageForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiMovePageForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
        }
    }
}

