/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.commons.UIWikiTemplateForm;
import org.exoplatform.wiki.webui.popup.UIWikiPagePreview;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/commons/UIWikiTemplateForm.gtmpl", events={@EventConfig(listeners={AddPageWithTemplateActionListener.class}), @EventConfig(listeners={PreviewTemplateActionListener.class}), @EventConfig(listeners={UIWikiTemplateForm.SearchTemplateActionListener.class})})
public class UIWikiSelectTemplateForm
extends UIWikiTemplateForm
implements UIPopupComponent {
    public static final String ACTION_PREVIEW = "PreviewTemplate";
    public static final String ACTION_ADD = "AddPageWithTemplate";
    public static final String ACTION_SEARCH = "SearchTemplate";
    private static final String[] USER_ACTION = new String[]{"AddPageWithTemplate", "PreviewTemplate"};

    public UIWikiSelectTemplateForm() throws Exception {
        this.grid.configure("id", TEMPLATE_FIELD, USER_ACTION);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewTemplateActionListener
    extends EventListener<UIWikiSelectTemplateForm> {
        public void execute(Event<UIWikiSelectTemplateForm> event) throws Exception {
            UIWikiSelectTemplateForm form = (UIWikiSelectTemplateForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)form.getAncestorOfType(UIWikiPortlet.class);
            UIWikiMaskWorkspace mask = (UIWikiMaskWorkspace)wikiPortlet.findFirstComponentOfType(UIWikiMaskWorkspace.class);
            UIWikiPagePreview wikiPagePreview = (UIWikiPagePreview)mask.createUIComponent(UIWikiPagePreview.class, null, null);
            String templateId = event.getRequestContext().getRequestParameter("objectId");
            Template template = form.wService.getTemplatePage(Utils.getCurrentWikiPageParams(), templateId);
            AttachmentImpl content = template.getContent();
            wikiPagePreview.renderWikiMarkup(content.getText(), template.getSyntax());
            String pageTitle = template.getTitle();
            if (pageTitle != null) {
                wikiPagePreview.setPageTitle(pageTitle);
            }
            mask.setUIComponent((UIComponent)wikiPagePreview);
            mask.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)mask);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPageWithTemplateActionListener
    extends EventListener<UIWikiSelectTemplateForm> {
        public void execute(Event<UIWikiSelectTemplateForm> event) throws Exception {
            UIWikiSelectTemplateForm form = (UIWikiSelectTemplateForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)form.getAncestorOfType(UIWikiPortlet.class);
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormStringInput descriptionInput = (UIFormStringInput)pageEditForm.findComponentById("Description");
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormSelectBox syntaxTypeSelectBox = (UIFormSelectBox)pageEditForm.findComponentById("SyntaxType");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            String templateId = event.getRequestContext().getRequestParameter("objectId");
            String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
            form.wService.createDraftNewPage(sessionId);
            titleInput.setEditable(true);
            commentInput.setRendered(false);
            Template template = form.wService.getTemplatePage(Utils.getCurrentWikiPageParams(), templateId);
            titleInput.setValue((Object)template.getTitle());
            descriptionInput.setValue((Object)template.getDescription());
            pageEditForm.setTitle(template.getTitle());
            markupInput.setValue((Object)template.getContent().getText());
            syntaxTypeSelectBox.setValue(template.getSyntax());
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.deActivate();
            wikiPortlet.changeMode(WikiMode.ADDPAGE);
        }
    }
}

