/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

public class PrettyXmlSerializer
extends XmlSerializer {
    private static final String INDENTATION_STRING = "\t";

    public PrettyXmlSerializer(CleanerProperties cleanerProperties) {
        super(cleanerProperties);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializePrettyXml(tagNode, writer, 0);
    }

    private String indent(int n) {
        String string = "";
        while (n > 0) {
            string = string + INDENTATION_STRING;
            --n;
        }
        return string;
    }

    private String getIndentedText(String string, int n) {
        String string2 = this.indent(n);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if ("".equals(string3)) continue;
            stringBuffer.append(string2 + string3 + "\n");
        }
        return stringBuffer.toString();
    }

    private String getSingleLineOfChildren(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ContentToken)) {
                return null;
            }
            ContentToken contentToken = (ContentToken)e;
            String string = contentToken.getContent();
            if (bl) {
                string = Utils.ltrim(string);
            }
            if (!iterator.hasNext()) {
                string = Utils.rtrim(string);
            }
            if (string.indexOf("\n") >= 0 || string.indexOf("\r") >= 0) {
                return null;
            }
            stringBuffer.append(string);
            bl = false;
        }
        return stringBuffer.toString();
    }

    protected void serializePrettyXml(TagNode tagNode, Writer writer, int n) throws IOException {
        List list = tagNode.getChildren();
        String string = this.indent(n);
        writer.write(string);
        this.serializeOpenTag(tagNode, writer);
        if (!this.isMinimizedTagSyntax(tagNode)) {
            String string2 = this.getSingleLineOfChildren(list);
            boolean bl = this.dontEscape(tagNode);
            if (string2 != null) {
                if (!this.dontEscape(tagNode)) {
                    writer.write(this.escapeXml(string2));
                } else {
                    writer.write(string2.replaceAll("]]>", "]]&gt;"));
                }
            } else {
                writer.write("\n");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    BaseToken baseToken;
                    Object e = iterator.next();
                    if (e instanceof TagNode) {
                        this.serializePrettyXml((TagNode)e, writer, n + 1);
                        continue;
                    }
                    if (e instanceof ContentToken) {
                        baseToken = (ContentToken)e;
                        string3 = bl ? ((ContentToken)baseToken).getContent().replaceAll("]]>", "]]&gt;") : this.escapeXml(((ContentToken)baseToken).getContent());
                        writer.write(this.getIndentedText(string3, n + 1));
                        continue;
                    }
                    if (!(e instanceof CommentToken)) continue;
                    baseToken = (CommentToken)e;
                    string3 = ((CommentToken)baseToken).getCommentedContent();
                    writer.write(this.getIndentedText(string3, n + 1));
                }
            }
            if (string2 == null) {
                writer.write(string);
            }
            this.serializeEndTag(tagNode, writer);
        }
    }
}

