/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.injector;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.platform.organization.injector.DataPlugin;
import org.exoplatform.platform.organization.injector.SerializationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInjectorService
implements Startable {
    private static final String CONFIGURATION_XML_SUFFIX = "-configuration.xml";
    private static final Log logger_ = ExoLogger.getLogger(DataInjectorService.class);
    private List<UserImpl> usersData = new ArrayList<UserImpl>();
    private List<UserProfileImpl> userProfilesData = new ArrayList<UserProfileImpl>();
    private OrganizationService organizationService;
    private PicketLinkIDMService picketLinkIDMService;
    private ConfigurationManager configurationManager;
    private List<DataPlugin> dataPlugins = new ArrayList<DataPlugin>();

    public DataInjectorService(OrganizationService organizationService, ConfigurationManager configurationManager) {
        this.organizationService = organizationService;
        this.configurationManager = configurationManager;
        this.picketLinkIDMService = (PicketLinkIDMService)PortalContainer.getInstance().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    public void start() {
        try {
            this.doImport(false);
        }
        catch (Exception exception) {
            logger_.error((Object)"Cannot inject Organization Model Data", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(boolean isArchive) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            for (DataPlugin dataPlugin : this.dataPlugins) {
                dataPlugin.init();
            }
            if (!isArchive) {
                for (DataPlugin dataPlugin : this.dataPlugins) {
                    List users = dataPlugin.getConfig().getUser();
                    if (users == null || users.isEmpty()) continue;
                    for (OrganizationConfig.User injectedUser : users) {
                        String xmlContent = this.getXMLContent("users/" + injectedUser.getUserName() + "_user.xml");
                        if (xmlContent != null) {
                            XStream xstreamUser_ = new XStream((HierarchicalStreamDriver)new XppDriver());
                            xstreamUser_.alias("user", UserImpl.class);
                            UserImpl userToImport = (UserImpl)xstreamUser_.fromXML(new String(xmlContent));
                            User user = this.organizationService.getUserHandler().findUserByName(userToImport.getUserName());
                            if (userToImport.getLastLoginTime() != null) {
                                user.setLastLoginTime(userToImport.getLastLoginTime());
                            }
                            if (userToImport.getCreatedDate() != null) {
                                user.setCreatedDate(userToImport.getCreatedDate());
                            }
                            this.organizationService.getUserHandler().saveUser(user, false);
                        }
                        if ((xmlContent = this.getXMLContent("profiles/" + injectedUser.getUserName() + "_profile.xml")) == null) continue;
                        XStream xstreamProfile_ = new XStream((HierarchicalStreamDriver)new XppDriver());
                        xstreamProfile_.alias("user-profile", UserProfileImpl.class);
                        UserProfileImpl userProfile = (UserProfileImpl)xstreamProfile_.fromXML(xmlContent);
                        this.organizationService.getUserProfileHandler().saveUserProfile((UserProfile)userProfile, false);
                    }
                }
            } else {
                User user;
                for (UserImpl importedUser : this.usersData) {
                    user = this.organizationService.getUserHandler().findUserByName(importedUser.getUserName());
                    if (user != null) {
                        if (importedUser.getLastLoginTime() != null) {
                            user.setLastLoginTime(importedUser.getLastLoginTime());
                        }
                        if (importedUser.getCreatedDate() != null) {
                            user.setCreatedDate(importedUser.getCreatedDate());
                        }
                        this.organizationService.getUserHandler().saveUser(user, false);
                        continue;
                    }
                    logger_.warn((Object)("user = " + importedUser.getUserName() + " doesn't exist"));
                }
                for (UserProfileImpl userProfile : this.userProfilesData) {
                    user = this.organizationService.getUserHandler().findUserByName(userProfile.getUserName());
                    if (user != null) {
                        this.organizationService.getUserProfileHandler().saveUserProfile((UserProfile)userProfile, true);
                        continue;
                    }
                    logger_.warn((Object)("userProfile = " + userProfile.getUserName() + " doesn't exist"));
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void addDataPlugin(DataPlugin dataPlugin) {
        this.dataPlugins.add(dataPlugin);
    }

    public void readDataPlugins(String filePath) throws Exception {
        this.dataPlugins.clear();
        FileInputStream fin = new FileInputStream(filePath);
        ZipInputStream zin = new ZipInputStream(fin);
        ZipEntry ze = null;
        while ((ze = zin.getNextEntry()) != null) {
            if (!ze.getName().equals("configuration.xml") && !ze.getName().contains(CONFIGURATION_XML_SUFFIX)) continue;
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            int c = zin.read();
            while (c != -1) {
                fout.write(c);
                c = zin.read();
            }
            zin.closeEntry();
            Configuration tmpConfiguration = SerializationUtils.fromXML(fout.toByteArray(), Configuration.class);
            Component component = tmpConfiguration.getComponent(DataInjectorService.class.getName());
            ExternalComponentPlugins externalComponentPlugins = tmpConfiguration.getExternalComponentPlugins(DataInjectorService.class.getName());
            if (component != null && component.getComponentPlugins() != null && !component.getComponentPlugins().isEmpty()) {
                this.addComponentPlugins(component.getComponentPlugins());
                continue;
            }
            if (externalComponentPlugins == null || externalComponentPlugins.getComponentPlugins() == null || externalComponentPlugins.getComponentPlugins().isEmpty()) continue;
            this.addComponentPlugins(externalComponentPlugins.getComponentPlugins());
        }
        zin.close();
    }

    private void addComponentPlugins(List<ComponentPlugin> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        for (ComponentPlugin plugin : plugins) {
            try {
                DataPlugin dataPlugin = (DataPlugin)((Object)PortalContainer.getInstance().createComponent(DataPlugin.class, plugin.getInitParams()));
                dataPlugin.setName(plugin.getName());
                dataPlugin.setDescription(plugin.getDescription());
                this.addDataPlugin(dataPlugin);
            }
            catch (Exception e) {
                logger_.error((Object)("Failed to instanciate component plugin " + plugin.getName() + ", type=" + plugin.getClass()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOrganizationModelData(ZipOutputStream zos) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Configuration configuration = new Configuration();
            Component component = new Component();
            component.setType(DataInjectorService.class.getName());
            configuration.addComponent((Object)component);
            List<OrganizationConfig.Group> groups = this.getAllGroups();
            List<OrganizationConfig.MembershipType> membershipTypes = this.getAllMembershipTypes();
            Configuration organizationServiceConfiguration = SerializationUtils.buildOrganizationServiceConfiguration(SerializationUtils.getOrganizationConfig(groups, membershipTypes, null));
            SerializationUtils.addEntry(zos, SerializationUtils.toXML(organizationServiceConfiguration), "OrganizationDataModel/Groups-MembershipTypes-configuration.xml");
            configuration.addImport("OrganizationDataModel/Groups-MembershipTypes-configuration.xml");
            ListAccess usersListAccess = this.organizationService.getUserHandler().findAllUsers();
            ArrayList<OrganizationConfig.User> orgConfigUsersInSigleFile = new ArrayList<OrganizationConfig.User>();
            for (int i = 0; i <= usersListAccess.getSize(); i += 100) {
                User[] users;
                int length = i + 100 <= usersListAccess.getSize() ? 100 : usersListAccess.getSize() - i;
                for (User user : users = (User[])usersListAccess.load(i, length)) {
                    OrganizationConfig.User orgConfigUser = this.convertUserToSerializableObject(user);
                    orgConfigUsersInSigleFile.add(orgConfigUser);
                }
                Configuration organizationServiceConfiguration2 = SerializationUtils.buildOrganizationServiceConfiguration(SerializationUtils.getOrganizationConfig(null, null, orgConfigUsersInSigleFile));
                SerializationUtils.addEntry(zos, SerializationUtils.toXML(organizationServiceConfiguration2), "OrganizationDataModel/Users" + i + CONFIGURATION_XML_SUFFIX);
                orgConfigUsersInSigleFile.clear();
                configuration.addImport("OrganizationDataModel/Users" + i + CONFIGURATION_XML_SUFFIX);
            }
            SerializationUtils.addEntry(zos, SerializationUtils.toXML(configuration), "configuration.xml");
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProfiles(ZipOutputStream zos) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ListAccess usersListAccess = this.organizationService.getUserHandler().findAllUsers();
            XStream xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
            for (int i = 0; i <= usersListAccess.getSize(); i += 100) {
                User[] users;
                int length = i + 100 <= usersListAccess.getSize() ? 100 : usersListAccess.getSize() - i;
                for (User user : users = (User[])usersListAccess.load(i, length)) {
                    UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(user.getUserName());
                    if (userProfile == null || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty()) continue;
                    xstream_.alias("user-profile", userProfile.getClass());
                    String xml = xstream_.toXML((Object)userProfile);
                    zos.putNextEntry(new ZipEntry("profiles/" + userProfile.getUserName() + "_profile.xml"));
                    zos.write(xml.getBytes());
                    zos.closeEntry();
                    if (!logger_.isDebugEnabled()) continue;
                    logger_.debug((Object)("Adding entry for userProfile: " + userProfile.getUserName()));
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUsers(ZipOutputStream zos) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Adding entries for each user, additional fields are missing: LastLoginTime & CreatedDate");
            }
            ListAccess usersListAccess = this.organizationService.getUserHandler().findAllUsers();
            XStream xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
            for (int i = 0; i <= usersListAccess.getSize(); i += 100) {
                User[] users;
                int length = i + 100 <= usersListAccess.getSize() ? 100 : usersListAccess.getSize() - i;
                for (User user : users = (User[])usersListAccess.load(i, length)) {
                    if (user == null) continue;
                    xstream_.alias("user", user.getClass());
                    String xml = xstream_.toXML((Object)user);
                    zos.putNextEntry(new ZipEntry("users/" + user.getUserName() + "_user.xml"));
                    zos.write(xml.getBytes());
                    zos.closeEntry();
                    if (!logger_.isDebugEnabled()) continue;
                    logger_.debug((Object)("Adding entry for user: " + user.getUserName()));
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private OrganizationConfig.User convertUserToSerializableObject(User user) throws Exception {
        OrganizationConfig.User orgConfigUser = new OrganizationConfig.User();
        orgConfigUser.setEmail(user.getEmail());
        orgConfigUser.setFirstName(user.getFirstName());
        orgConfigUser.setLastName(user.getLastName());
        if (this.organizationService instanceof PicketLinkIDMOrganizationServiceImpl) {
            orgConfigUser.setPassword(this.readPasswordFromPicketLink(user));
        } else {
            orgConfigUser.setPassword(user.getPassword());
        }
        orgConfigUser.setUserName(user.getUserName());
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
        String groups = "";
        for (Membership membership : memberships) {
            groups = groups + membership.getMembershipType() + ":" + membership.getGroupId() + ",";
            groups.substring(0, groups.lastIndexOf(","));
        }
        orgConfigUser.setGroups(groups);
        return orgConfigUser;
    }

    public void readUsersData(String filePath) throws Exception {
        this.usersData.clear();
        XStream xstreamUser_ = new XStream((HierarchicalStreamDriver)new XppDriver());
        xstreamUser_.alias("user", UserImpl.class);
        FileInputStream fin = new FileInputStream(filePath);
        ZipInputStream zin = new ZipInputStream(fin);
        ZipEntry ze = null;
        while ((ze = zin.getNextEntry()) != null) {
            if (!ze.getName().contains("_user.xml")) continue;
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            int c = zin.read();
            while (c != -1) {
                fout.write(c);
                c = zin.read();
            }
            zin.closeEntry();
            UserImpl importedUser = (UserImpl)xstreamUser_.fromXML(new String(fout.toByteArray()));
            this.usersData.add(importedUser);
        }
        zin.close();
    }

    public void readUserProfilesData(String filePath) throws Exception {
        this.userProfilesData.clear();
        XStream xstreamProfile_ = new XStream((HierarchicalStreamDriver)new XppDriver());
        xstreamProfile_.alias("user-profile", UserProfileImpl.class);
        FileInputStream fin = new FileInputStream(filePath);
        ZipInputStream zin = new ZipInputStream(fin);
        ZipEntry ze = null;
        while ((ze = zin.getNextEntry()) != null) {
            if (!ze.getName().contains("_profile.xml")) continue;
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            int c = zin.read();
            while (c != -1) {
                fout.write(c);
                c = zin.read();
            }
            zin.closeEntry();
            UserProfileImpl userProfile = (UserProfileImpl)xstreamProfile_.fromXML(new String(fout.toByteArray()));
            this.userProfilesData.add(userProfile);
        }
        zin.close();
    }

    private List<OrganizationConfig.Group> getAllGroups() throws Exception {
        ArrayList<OrganizationConfig.Group> allGroups = new ArrayList<OrganizationConfig.Group>();
        try {
            Collection groups = this.organizationService.getGroupHandler().getAllGroups();
            for (Group group : groups) {
                OrganizationConfig.Group orgConfGroup = new OrganizationConfig.Group();
                orgConfGroup.setDescription(group.getDescription());
                orgConfGroup.setLabel(group.getLabel());
                orgConfGroup.setName(group.getGroupName());
                orgConfGroup.setParentId(group.getParentId());
                allGroups.add(orgConfGroup);
            }
        }
        catch (Exception e) {
            logger_.error((Object)"Error when recovering of all groups ... ", (Throwable)e);
            return null;
        }
        return allGroups;
    }

    private List<OrganizationConfig.MembershipType> getAllMembershipTypes() throws Exception {
        ArrayList<OrganizationConfig.MembershipType> allMembershipTypes = new ArrayList<OrganizationConfig.MembershipType>();
        try {
            Collection membershipTypes = this.organizationService.getMembershipTypeHandler().findMembershipTypes();
            for (MembershipType membershipType : membershipTypes) {
                OrganizationConfig.MembershipType orgConfMemberShipType = new OrganizationConfig.MembershipType();
                orgConfMemberShipType.setDescription(membershipType.getDescription());
                orgConfMemberShipType.setType(membershipType.getName());
                allMembershipTypes.add(orgConfMemberShipType);
            }
        }
        catch (Exception e) {
            logger_.error((Object)"Error when recovering of all membershipTypes ... ", (Throwable)e);
            return null;
        }
        return allMembershipTypes;
    }

    private String getXMLContent(String filePath) {
        String xmlContent = null;
        try {
            InputStream xmlInputStream = this.configurationManager.getInputStream(filePath);
            byte[] bytes = new byte[xmlInputStream.available()];
            xmlInputStream.read(bytes);
            xmlContent = new String(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlContent;
    }

    private String readPasswordFromPicketLink(User user) throws Exception {
        PicketLinkIDMOrganizationServiceImpl orgService = (PicketLinkIDMOrganizationServiceImpl)this.organizationService;
        if (orgService.getConfiguration().isPasswordAsAttribute()) {
            return user.getPassword();
        }
        IdentitySession identitySession = this.picketLinkIDMService.getIdentitySession();
        IdentityStoreInvocationContext identitySessionContext = ((IdentitySessionImpl)identitySession).getSessionContext().resolveStoreInvocationContext();
        Session session = (Session)((RepositoryIdentityStoreSessionImpl)identitySessionContext.getIdentityStoreSession()).getIdentityStoreSession("HibernateStore").getSessionContext();
        HibernateIdentityObjectType hibernateIdentityObjectType = (HibernateIdentityObjectType)session.createCriteria(HibernateIdentityObjectType.class).add((Criterion)Restrictions.eq((String)"name", (Object)"USER")).uniqueResult();
        HibernateIdentityObject hibernateUserObject = (HibernateIdentityObject)session.createCriteria(HibernateIdentityObject.class).add((Criterion)Restrictions.eq((String)"name", (Object)user.getUserName())).add((Criterion)Restrictions.eq((String)"identityType", (Object)hibernateIdentityObjectType)).uniqueResult();
        HibernateIdentityObjectCredential hibernateCredential = (HibernateIdentityObjectCredential)session.createCriteria(HibernateIdentityObjectCredential.class).createAlias("type", "t").add((Criterion)Restrictions.eq((String)"t.name", (Object)PasswordCredential.TYPE.getName())).add((Criterion)Restrictions.eq((String)"identityObject", (Object)hibernateUserObject)).setCacheable(true).uniqueResult();
        if (hibernateCredential != null) {
            return hibernateCredential.getTextValue();
        }
        return "";
    }
}

