/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.user;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class AutoPruneJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        try {
            ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
            String desc = context.getJobDetail().getDescription();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            repositoryService.setCurrentRepositoryName(context.getJobDetail().getJobDataMap().getString(Utils.CACHE_REPO_NAME));
            forumService.runPrune(desc);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("\n\nAuto prune has worked on " + desc + " forum"));
            }
        }
        catch (Exception e) {
            log_.debug((Object)("\n\n >>>>>> AutoPrune Job error" + e.getMessage()));
        }
        finally {
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

