/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.jdbm.JdbmCacheLoaderConfig;
import org.jboss.cache.loader.jdbm.JdbmFqnComparator;
import org.jboss.cache.loader.jdbm.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JdbmCacheLoader
extends AbstractCacheLoader {
    private static final Log log = LogFactory.getLog(JdbmCacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final String KEYS = "K";
    private static final String NODE = "N";
    private static final String NAME = "JdbmCacheLoader";
    private JdbmCacheLoaderConfig config;
    RecordManager recman;
    BTree tree;

    @Override
    public void create() throws Exception {
        this.checkNotOpen();
    }

    @Override
    public void start() throws Exception {
        boolean created;
        String cacheDbName;
        int offset;
        log.trace((Object)("Starting " + this.getClass().getSimpleName() + " instance."));
        this.checkNotOpen();
        this.checkNonNull(this.cache, "CacheSPI object is required");
        String locationStr = this.config.getLocation();
        if (locationStr == null) {
            locationStr = System.getProperty("java.io.tmpdir");
            this.config.setLocation(locationStr);
        }
        if ((offset = locationStr.indexOf(35)) >= 0 && offset < locationStr.length() - 1) {
            cacheDbName = locationStr.substring(offset + 1);
            locationStr = locationStr.substring(0, offset);
        } else {
            cacheDbName = this.cache.getClusterName();
            if (cacheDbName == null) {
                cacheDbName = "CacheInstance-" + System.identityHashCode(this.cache);
            }
        }
        File location = new File(locationStr);
        if (!location.exists() && !(created = location.mkdirs())) {
            throw new IOException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new IOException("Cache loader location [" + location + "] is not a directory!");
        }
        try {
            this.openDatabase(new File(location, cacheDbName));
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void openDatabase(File f) throws Exception {
        Properties props = new Properties();
        this.recman = RecordManagerFactory.createRecordManager((String)f.toString(), (Properties)props);
        long recid = this.recman.getNamedObject(NAME);
        log.debug((Object)("JdbmCacheLoader located as " + recid));
        if (recid == 0L) {
            this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new JdbmFqnComparator());
            this.recman.setNamedObject(NAME, this.tree.getRecid());
        } else {
            this.tree = BTree.load((RecordManager)this.recman, (long)recid);
        }
        log.info((Object)("JDBM database " + f + " opened with " + this.tree.size() + " entries"));
    }

    private void closeDatabases() {
        if (this.recman != null) {
            try {
                this.recman.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.recman = null;
        this.tree = null;
    }

    @Override
    public void stop() {
        log.debug((Object)"stop");
        this.closeDatabases();
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.checkNotOpen();
        this.config = base instanceof JdbmCacheLoaderConfig ? (JdbmCacheLoaderConfig)base : this.createConfig(base);
        if (trace) {
            log.trace((Object)("Configuring cache loader with location = " + this.config.getLocation()));
        }
    }

    JdbmCacheLoaderConfig createConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        return new JdbmCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public void setCache(CacheSPI c) {
        super.setCache(c);
        this.checkNotOpen();
    }

    private Fqn keys(Fqn name) {
        return Fqn.fromRelativeElements(name, KEYS);
    }

    private Fqn key(Fqn name, Object key) {
        return Fqn.fromRelativeElements(name, KEYS, this.nullMask(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<?> getChildrenNames(Fqn name) throws IOException {
        if (trace) {
            log.trace((Object)("getChildrenNames " + name));
        }
        BTree bTree = this.tree;
        synchronized (bTree) {
            return this.getChildrenNames0(name);
        }
    }

    Set<Object> getChildrenNames0(Fqn name) throws IOException {
        Fqn fqn;
        int size;
        Tuple t;
        TupleBrowser browser = this.tree.browse((Object)name);
        if (browser.getNext(t = new Tuple())) {
            if (!t.getValue().equals(NODE)) {
                log.trace((Object)" not a node");
                return null;
            }
        } else {
            log.trace((Object)" no nodes");
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        int depth = name.size() + 1;
        while (browser.getNext(t) && (size = (fqn = (Fqn)t.getKey()).size()) >= depth) {
            if (size != depth || !t.getValue().equals(NODE)) continue;
            set.add(fqn.getLastElement());
        }
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.tree.find((Object)name) == null) {
            if (trace) {
                log.trace((Object)("get, no node: " + name));
            }
            return null;
        }
        Fqn keys = this.keys(name);
        Tuple t = new Tuple();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser browser = this.tree.browse((Object)keys);
            while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(keys)) {
                Object k = fqn.getLastElement();
                Object v = t.getValue();
                map.put(this.nullUnmask(k), this.nullUnmask(v));
            }
        }
        if (trace) {
            log.trace((Object)("get " + name + " map=" + map));
        }
        return map;
    }

    @Override
    public boolean exists(Fqn name) throws IOException {
        return this.tree.find((Object)name) != null;
    }

    void commit() throws IOException {
        this.recman.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        try {
            Object object = this.put0(name, key, value);
            return object;
        }
        finally {
            this.commit();
        }
    }

    Object put0(Fqn name, Object key, Object value) throws Exception {
        this.checkNonNull(name, "name");
        this.makeNode(name);
        Fqn rec = this.key(name, key);
        Object oldValue = this.insert(rec, value);
        if (trace) {
            log.trace((Object)("put " + rec + " value=" + value + " old=" + oldValue));
        }
        return oldValue;
    }

    public void put(Fqn name, Map values) throws Exception {
        this.put0(name, values);
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put0(Fqn name, Map<?, ?> values) throws Exception {
        if (trace) {
            log.trace((Object)("put " + name + " values=" + values));
        }
        this.makeNode(name);
        if (values == null) {
            return;
        }
        Fqn keys = this.keys(name);
        Tuple t = new Tuple();
        ArrayList<Fqn> removeList = new ArrayList<Fqn>();
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser tupleBrowser = this.tree.browse((Object)keys);
            while (tupleBrowser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(keys)) {
                Object k = fqn.getLastElement();
                if (values.containsKey(this.nullUnmask(k))) continue;
                removeList.add(fqn);
            }
        }
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            Fqn rec = this.key(name, entry.getKey());
            this.insert(rec, this.nullMask(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : removeList) {
            this.tree.remove(entry);
        }
    }

    private void makeNode(Fqn fqn) throws IOException {
        int size;
        Fqn child;
        Object existing;
        if (this.exists(fqn)) {
            return;
        }
        for (int i = size = fqn.size(); i >= 0 && (existing = this.tree.insert(child = fqn.getAncestor(i), (Object)NODE, false)) == null; --i) {
        }
    }

    private Object insert(Fqn fqn, Object value) throws IOException {
        return this.nullUnmask(this.tree.insert((Object)fqn, this.nullMask(value), true));
    }

    private void erase0(Fqn name) throws IOException {
        this.erase0(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void erase0(Fqn name, boolean self) throws IOException {
        if (trace) {
            log.trace((Object)("erase " + name + " self=" + self));
        }
        ArrayList<Fqn> removeList = new ArrayList<Fqn>();
        BTree bTree = this.tree;
        synchronized (bTree) {
            TupleBrowser tupleBrowser = this.tree.browse((Object)name);
            Tuple t = new Tuple();
            boolean first = true;
            while (tupleBrowser.getNext(t)) {
                if (first && !self) {
                    first = false;
                    continue;
                }
                Fqn fqn = (Fqn)t.getKey();
                if (!fqn.isChildOrEquals(name)) break;
                removeList.add(fqn);
            }
        }
        for (Object e : removeList) {
            this.tree.remove(e);
        }
    }

    Object eraseKey0(Fqn name, Object key) throws IOException {
        if (trace) {
            log.trace((Object)("eraseKey " + name + " key " + key));
        }
        Fqn fqnKey = this.key(name, key);
        try {
            return this.tree.remove((Object)fqnKey);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        block9: for (Modification m : modifications) {
            switch (m.getType()) {
                case PUT_DATA: {
                    this.put0(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_DATA_ERASE: {
                    this.erase0(m.getFqn(), false);
                    this.put0(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_KEY_VALUE: {
                    this.put0(m.getFqn(), m.getKey(), m.getValue());
                    continue block9;
                }
                case REMOVE_DATA: {
                    this.erase0(m.getFqn(), false);
                    continue block9;
                }
                case REMOVE_KEY_VALUE: {
                    this.eraseKey0(m.getFqn(), m.getKey());
                    continue block9;
                }
                case REMOVE_NODE: {
                    this.erase0(m.getFqn());
                    continue block9;
                }
                case MOVE: {
                    this.move(m.getFqn(), m.getFqn2());
                    continue block9;
                }
            }
            throw new CacheException("Unknown modification " + (Object)((Object)m.getType()));
        }
        this.commit();
    }

    @Override
    public void remove(Fqn name) throws IOException {
        this.erase0(name);
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        try {
            Object object = this.eraseKey0(name, key);
            return object;
        }
        finally {
            this.commit();
        }
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.erase0(name, false);
    }

    void checkOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Operation not allowed before calling create()");
        }
    }

    protected void checkNotOpen() {
        if (this.tree != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    protected void checkNonNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("Parameter must not be null: " + paramName);
        }
    }

    private Object nullMask(Object o) {
        return o == null ? Null.NULL : o;
    }

    private Object nullUnmask(Object o) {
        return o == Null.NULL ? null : o;
    }

    public void dump() throws IOException {
        this.dump(Fqn.ROOT);
    }

    public void dump(Object key) throws IOException {
        TupleBrowser browser = this.tree.browse(key);
        Tuple t = new Tuple();
        log.debug((Object)("contents: " + key));
        while (browser.getNext(t)) {
            log.debug((Object)(t.getKey() + "\t" + t.getValue()));
        }
        log.debug((Object)"");
    }

    public int size() {
        return this.tree.size();
    }

    public String toString() {
        BTree bt = this.tree;
        int size = bt == null ? -1 : bt.size();
        return "JdbmCacheLoader locationStr=" + this.config.getLocation() + " size=" + size;
    }
}

