/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration.rw;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.extras.migration.io.NodeData;
import org.exoplatform.social.extras.migration.io.NodeStreamHandler;
import org.exoplatform.social.extras.migration.io.WriterContext;
import org.exoplatform.social.extras.migration.rw.NodeWriter;
import org.exoplatform.social.extras.migration.rw.RemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWriter_11x_12x
implements NodeWriter {
    private final IdentityStorage identityStorage;
    private final RelationshipStorage relationshipStorage;
    private final SpaceStorage spaceStorage;
    private final ActivityStorage activityStorage;
    private final OrganizationService organizationService;
    private final RemoveManager removeManager;
    private final Session session;
    private final String NT_IDENTITY = "exo:identity";
    private final String NT_PROFILE = "exo:profile";
    private final String NT_PROFILE_DETAIL = "exo:profileKeyValue";
    private final String NT_PROFILE_XP = "exo:profileExperience";
    private final String NT_PROFILE_EDU = "exo:profileEducation";
    private final String NT_PROFILE_ADDR = "exo:profileAddress";
    private final String NT_REL_PROP = "exo:relationshipProperty";
    private final String NT_REL = "exo:relationship";
    private final String NT_ACTIVITY = "exo:activity";
    private final String NT_SPACE = "exo:space";
    private final String PATH_EXO_APPLICATION = "exo:applications";
    private final String PATH_SOC_ACTIVITY = "Social_Activity";
    private final String PATH_SOC_RELATIONSHIP = "Social_Relationship";
    private final String PATH_SOC_PROFILE = "Social_Profile";
    private final String PATH_SOC_SPACE = "Social_Space/Space";
    private final String PATH_SOC_IDENTITY = "Social_Identity";
    private final String PROP_PROVIDER_ID = "exo:providerId";
    private final String PROP_REMOTE_ID = "exo:remoteId";
    private final String PROP_NAME = "exo:name";
    private final String PROP_APP = "exo:app";
    private final String PROP_DESC = "exo:description";
    private final String PROP_GROUP_ID = "exo:groupId";
    private final String PROP_PRIORITY = "exo:priority";
    private final String PROP_REGISTRATION = "exo:registration";
    private final String PROP_TYPE = "exo:type";
    private final String PROP_EURL = "exo:url";
    private final String PROP_VISIBILITY = "exo:visibility";
    private final String PROP_USER_PENDING = "exo:pendingUsers";
    private final String PROP_USER_INVITED = "exo:invitedUsers";
    private final String PROP_IDENTITY_REF = "exo:identity";
    private final String PROP_IDENTITY1_REF = "exo:identity1Id";
    private final String PROP_IDENTITY2_REF = "exo:identity2Id";
    private final String PROP_RECIPROCAL_REF = "soc:reciprocal";
    private final String PROP_STATUS = "exo:status";
    private final String REL_STATUS_CONFIRMED = "CONFIRM";
    private final String REL_STATUS_PENDING = "PENDING";
    private final String PROP_KEY = "key";
    private final String PROP_VALUE = "value";
    private final String PROP_IMS = "ims";
    private final String PROP_PHONES = "phones";
    private final String PROP_URLS = "urls";
    private final String PROP_EMAILS = "emails";
    private final String PROP_POSITION = "position";
    private final String PROP_SKILLS = "skills";
    private final String PROP_DEPARTMENT = "department";
    private final String PROP_COMPANY = "company";
    private final String PROP_START_DATE = "startDate";
    private final String PROP_END_DATE = "endDate";
    private final String PROP_IS_CURRENT = "isCurrent";
    private final String PROP_FIRST_NAME = "firstName";
    private final String PROP_LAST_NAME = "lastName";
    private final String PROP_USERNAME = "username";
    private final String PROP_GENDER = "gender";
    private final String PROP_URL = "Url";
    private final String PROP_TITLE = "exo:title";
    private final String PROP_TITLE_TEMPLATE = "exo:titleTemplate";
    private final String PROP_BODY = "exo:body";
    private final String PROP_BODY_TEMPLATE = "exo:bodyTemplate";
    private final String PROP_USER_ID = "exo:userId";
    private final String PROP_POSTED_TIME = "exo:postedTime";
    private final String PROP_UPDATED_TIME = "exo:updatedTimestamp";
    private final String PROP_REPLY = "exo:replyToId";
    private final String PROP_EXTERNAL_ID = "exo:externalId";
    private final String PROP_PARAMS = "exo:params";
    private final String PROP_LIKE = "exo:likeIdentityIds";
    private final String PATH_ACTIVITIES = "/exo:applications/Social_Activity";
    private final String ORGA_MEMBER = "member";
    private final String ORGA_MANAGER = "manager";
    private final String PROVIDER_SPACE = "space";
    private final String PROVIDER_ORGANIZATION = "organization";
    private final String JCR_PRIMARYTYPE = "jcr:primaryType";
    private final String JCR_UUID = "jcr:uuid";
    private final String JCR_MIME_TYPE = "jcr:mimeType";
    private final String JCR_DATA = "jcr:data";
    private final String CTX_UUID = "id";
    private final String CTX_REMOTE_ID = "remoteId";
    private static final Log LOG = ExoLogger.getLogger(NodeWriter_11x_12x.class);

    public NodeWriter_11x_12x(IdentityStorage identityStorage, RelationshipStorage relationshipStorage, SpaceStorage spaceStorage, ActivityStorage activityStorage, OrganizationService organizationService, Session session) {
        this.identityStorage = identityStorage;
        this.relationshipStorage = relationshipStorage;
        this.spaceStorage = spaceStorage;
        this.activityStorage = activityStorage;
        this.organizationService = organizationService;
        this.session = session;
        this.removeManager = new RemoveManager(10, session);
    }

    @Override
    public void writeIdentities(InputStream is, WriterContext ctx) {
        NodeData currentData;
        NodeStreamHandler handler = new NodeStreamHandler();
        while ((currentData = handler.readNode(is)) != null) {
            String provider = (String)currentData.get("exo:providerId");
            String uuid = (String)currentData.get("jcr:uuid");
            String remote = (String)currentData.get("exo:remoteId");
            try {
                User user = this.organizationService.getUserHandler().findUserByName(remote);
                if (user == null && "organization".equals(provider)) {
                    continue;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
            if ("space".equals(provider)) {
                ctx.put(uuid + "-" + "remoteId", remote);
                continue;
            }
            Identity identity = new Identity(provider, remote);
            try {
                this.identityStorage.saveIdentity(identity);
                LOG.info((Object)("Write identity " + provider + "/" + remote));
                ctx.incDone(WriterContext.DataType.IDENTITIES);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
            if (uuid == null) continue;
            ctx.put(uuid + "-" + "remoteId", (String)currentData.get("exo:remoteId"));
            ctx.put(uuid + "-" + "id", identity.getId());
        }
        ctx.setCompleted(WriterContext.DataType.IDENTITIES);
    }

    @Override
    public void writeSpaces(InputStream is, WriterContext ctx) {
        NodeData currentData;
        NodeStreamHandler handler = new NodeStreamHandler();
        while ((currentData = handler.readNode(is)) != null) {
            String name = (String)currentData.get("exo:name");
            String app = (String)currentData.get("exo:app");
            String description = (String)currentData.get("exo:description");
            String groupId = (String)currentData.get("exo:groupId");
            String priority = (String)currentData.get("exo:priority");
            String registration = (String)currentData.get("exo:registration");
            String type = (String)currentData.get("exo:type");
            String url = (String)currentData.get("exo:url");
            String visibility = (String)currentData.get("exo:visibility");
            String[] pendingUsers = (String[])currentData.get("exo:pendingUsers");
            String[] invitedUsers = (String[])currentData.get("exo:invitedUsers");
            String[] members = null;
            String[] managers = null;
            try {
                Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
                Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByGroup(group);
                ArrayList<String> membersList = new ArrayList<String>();
                ArrayList<String> managersList = new ArrayList<String>();
                for (Membership membership : memberships) {
                    if ("member".equals(membership.getMembershipType())) {
                        membersList.add(membership.getUserName());
                        continue;
                    }
                    if (!"manager".equals(membership.getMembershipType())) continue;
                    managersList.add(membership.getUserName());
                }
                if (membersList.size() > 0) {
                    members = membersList.toArray(new String[0]);
                }
                if (managersList.size() > 0) {
                    managers = managersList.toArray(new String[0]);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
            Space space = new Space();
            space.setDisplayName(name);
            space.setApp(app);
            space.setDescription(description);
            space.setGroupId(groupId);
            space.setPriority(priority);
            space.setRegistration(registration);
            space.setType(type);
            space.setUrl(url);
            space.setVisibility(visibility);
            space.setPendingUsers(this.checkUser(pendingUsers));
            space.setInvitedUsers(this.checkUser(invitedUsers));
            space.setMembers(members);
            space.setManagers(managers);
            Identity identity = new Identity("space", space.getPrettyName());
            try {
                this.identityStorage.saveIdentity(identity);
                LOG.info((Object)("Write space identity " + identity.getProviderId() + "/" + identity.getRemoteId()));
                this.spaceStorage.saveSpace(space, true);
                LOG.info((Object)("Write space " + space.getGroupId()));
                ctx.incDone(WriterContext.DataType.SPACES);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
            ctx.put(currentData.get("jcr:uuid") + "-" + "remoteId", space.getPrettyName());
            ctx.put(currentData.get("jcr:uuid") + "-" + "id", identity.getId());
        }
        ctx.setCompleted(WriterContext.DataType.SPACES);
    }

    @Override
    public void writeProfiles(InputStream is, WriterContext ctx) {
        NodeData currentData;
        Identity currentIdentity = null;
        NodeStreamHandler handler = new NodeStreamHandler();
        while ((currentData = handler.readNode(is)) != null) {
            if ("exo:profile".equals(currentData.get("jcr:primaryType"))) {
                currentIdentity = this.handleProfileBasic(currentData, ctx);
                continue;
            }
            if ("exo:profileKeyValue".equals(currentData.get("jcr:primaryType"))) {
                this.handleProfileContact(currentData, currentIdentity);
                continue;
            }
            if (!"exo:profileExperience".equals(currentData.get("jcr:primaryType"))) continue;
            this.handleProfileXp(currentData, currentIdentity);
        }
        ctx.setCompleted(WriterContext.DataType.PROFILES);
    }

    @Override
    public void writeActivities(InputStream is, WriterContext ctx) {
        NodeData currentData;
        NodeStreamHandler handler = new NodeStreamHandler();
        while ((currentData = handler.readNode(is)) != null) {
            String[] ids;
            Identity owner;
            String replyToId = (String)currentData.get("exo:replyToId");
            if ("IS_COMMENT".equals(replyToId)) continue;
            String ownerId = this.extractOwner(currentData);
            if (this.isOrganizationActivity(currentData)) {
                owner = this.identityStorage.findIdentity("organization", ownerId);
            } else {
                if (!this.isSpaceActivity(currentData)) continue;
                String spaceName = ctx.get(ownerId + "-" + "remoteId");
                owner = this.identityStorage.findIdentity("space", spaceName);
            }
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            String title = (String)currentData.get("exo:title");
            String titleTemplate = (String)currentData.get("exo:titleTemplate");
            String type = (String)currentData.get("exo:type");
            String userId = (String)currentData.get("exo:userId");
            String postedTime = (String)currentData.get("exo:postedTime");
            String updatedTimestamp = (String)currentData.get("exo:updatedTimestamp");
            String body = (String)currentData.get("exo:body");
            String bodyTemplate = (String)currentData.get("exo:bodyTemplate");
            String url = (String)currentData.get("exo:url");
            String priority = (String)currentData.get("exo:priority");
            String externalId = (String)currentData.get("exo:externalId");
            String[] params = (String[])currentData.get("exo:params");
            String[] likes = (String[])currentData.get("exo:likeIdentityIds");
            Map<String, String> paramMap = this.readParams(params);
            if (paramMap != null) {
                activity.setTemplateParams(paramMap);
            }
            activity.setTitle(title);
            activity.setTitleId(titleTemplate);
            activity.setBody(body);
            activity.setBodyId(bodyTemplate);
            activity.setUrl(url);
            activity.setExternalId(externalId);
            activity.setType(type);
            activity.setPostedTime(Long.valueOf(Long.parseLong(postedTime)));
            activity.setUpdated(new Date(Long.parseLong(updatedTimestamp)));
            if (likes != null) {
                String[] newLikes = new String[likes.length];
                for (int i = 0; i < likes.length; ++i) {
                    newLikes[i] = ctx.get(likes[i] + "-" + "id");
                }
                activity.setLikeIdentityIds(newLikes);
            }
            if (priority != null) {
                activity.setPriority(Float.valueOf(Float.parseFloat(priority)));
            }
            if (userId == null) {
                activity.setUserId(owner.getId());
            } else {
                String userName = ctx.get(userId + "-" + "remoteId");
                Identity i = this.identityStorage.findIdentity("organization", userName);
                if (i != null) {
                    activity.setUserId(i.getId());
                } else {
                    try {
                        Node oldSpaceIdentity = this.session.getNodeByUUID(userId);
                        String oldSpaceId = oldSpaceIdentity.getProperty("exo:remoteId").getString();
                        String spaceName = ctx.get(oldSpaceId + "-" + "remoteId");
                        Identity spaceIdentity = this.identityStorage.findIdentity("space", spaceName);
                        if (spaceIdentity != null) {
                            activity.setUserId(spaceIdentity.getId());
                        }
                    }
                    catch (RepositoryException e1) {
                        LOG.info((Object)("Ignore activity : " + activity.getPostedTime()));
                    }
                }
            }
            try {
                this.activityStorage.saveActivity(owner, (ExoSocialActivity)activity);
                LOG.info((Object)("Write activity " + owner.getRemoteId() + " : " + activity.getPostedTime()));
                ctx.incDone(WriterContext.DataType.ACTIVITIES);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
            if (replyToId == null) continue;
            for (String id : ids = replyToId.split(",")) {
                if ("".equals(id)) continue;
                try {
                    Node node = this.session.getNodeByUUID(id);
                    ExoSocialActivity comment = this.buildActivityFromNode(node, ctx);
                    if (comment.getUserId() == null) {
                        comment.setUserId(activity.getUserId());
                    }
                    try {
                        this.activityStorage.saveComment((ExoSocialActivity)activity, comment);
                        LOG.info((Object)("Write comment " + owner.getRemoteId() + " : " + activity.getPostedTime() + "/" + comment.getPostedTime()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage());
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)e);
                }
            }
        }
        ctx.setCompleted(WriterContext.DataType.ACTIVITIES);
    }

    @Override
    public void writeRelationships(InputStream is, WriterContext ctx) {
        NodeData currentData;
        NodeStreamHandler handler = new NodeStreamHandler();
        while ((currentData = handler.readNode(is)) != null) {
            String id1 = (String)currentData.get("exo:identity1Id");
            String id2 = (String)currentData.get("exo:identity2Id");
            String status = (String)currentData.get("exo:status");
            String remoteId1 = ctx.get(id1 + "-" + "remoteId");
            String remoteId2 = ctx.get(id2 + "-" + "remoteId");
            Identity i1 = this.identityStorage.findIdentity("organization", remoteId1);
            Identity i2 = this.identityStorage.findIdentity("organization", remoteId2);
            Relationship.Type type = null;
            if ("CONFIRM".equals(status)) {
                type = Relationship.Type.CONFIRMED;
            } else if ("PENDING".equals(status)) {
                type = Relationship.Type.PENDING;
            }
            Relationship relationship = new Relationship(i1, i2, type);
            try {
                this.relationshipStorage.saveRelationship(relationship);
                LOG.info((Object)("Write relationship " + i1.getRemoteId() + " -> " + i2.getRemoteId() + " : " + type));
                ctx.incDone(WriterContext.DataType.RELATIONSHIPS);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
        ctx.setCompleted(WriterContext.DataType.RELATIONSHIPS);
    }

    @Override
    public void rollback(WriterContext ctx) throws RepositoryException {
        NodeIterator itUserActivity = this.session.getRootNode().getNode("production/soc:providers/soc:organization").getNodes();
        while (itUserActivity.hasNext()) {
            NodeIterator itActivities = itUserActivity.nextNode().getNode("soc:activities").getNodes();
            while (itActivities.hasNext()) {
                Node activity = itActivities.nextNode();
                LOG.info((Object)("Removing activity " + activity.getPath()));
                this.removeManager.remove(activity);
            }
        }
        NodeIterator itSpaceActivity = this.session.getRootNode().getNode("production/soc:providers/soc:space").getNodes();
        while (itSpaceActivity.hasNext()) {
            NodeIterator itActivities = itSpaceActivity.nextNode().getNode("soc:activities").getNodes();
            while (itActivities.hasNext()) {
                Node activity = itActivities.nextNode();
                LOG.info((Object)("Removing activity " + activity.getPath()));
                this.removeManager.remove(activity);
            }
        }
        NodeIterator it = this.session.getRootNode().getNode("production/soc:providers/soc:organization").getNodes();
        while (it.hasNext()) {
            Node current = it.nextNode();
            this.removeRelationNode(current, "soc:relationship");
            this.removeRelationNode(current, "soc:sender");
            this.removeRelationNode(current, "soc:receiver");
            LOG.info((Object)("Removing relationship for " + current.getPath()));
        }
        NodeIterator itOrganization = this.session.getRootNode().getNode("production/soc:providers/soc:organization/").getNodes();
        while (itOrganization.hasNext()) {
            Node node = itOrganization.nextNode();
            LOG.info((Object)("Removing identity " + node.getPath()));
            this.removeManager.remove(node);
        }
        NodeIterator itSpaceIdentitiy = this.session.getRootNode().getNode("production/soc:providers/soc:space/").getNodes();
        while (itSpaceIdentitiy.hasNext()) {
            Node node = itSpaceIdentitiy.nextNode();
            LOG.info((Object)("Removing space identity " + node.getPath()));
            this.removeManager.remove(node);
        }
        NodeIterator itSpaces = this.session.getRootNode().getNode("production/soc:spaces/").getNodes();
        while (itSpaces.hasNext()) {
            Node node = itSpaces.nextNode();
            LOG.info((Object)("Removing space " + node.getPath()));
            this.removeManager.remove(node);
        }
        this.removeManager.complete();
        ctx.cleanup();
    }

    @Override
    public void commit(WriterContext ctx) throws RepositoryException {
        NodeIterator itActivity = this.session.getRootNode().getNode("exo:applications/Social_Activity").getNodes();
        while (itActivity.hasNext()) {
            NodeIterator itActivityProvider = itActivity.nextNode().getNodes();
            while (itActivityProvider.hasNext()) {
                Node userNode = itActivityProvider.nextNode();
                try {
                    Node publishedNode = userNode.getNode("published");
                    NodeIterator itActivityUser = publishedNode.getNodes();
                    while (itActivityUser.hasNext()) {
                        Node activityNode = itActivityUser.nextNode();
                        LOG.info((Object)("Removing activities " + activityNode.getPath()));
                        this.removeManager.remove(activityNode);
                    }
                }
                catch (PathNotFoundException e) {
                    LOG.error((Object)e.getMessage());
                }
                this.removeManager.remove(userNode);
            }
        }
        NodeIterator itRelationship = this.session.getRootNode().getNode("exo:applications/Social_Relationship").getNodes();
        while (itRelationship.hasNext()) {
            Node relationshipNode = itRelationship.nextNode();
            LOG.info((Object)("Removing relationship " + relationshipNode.getPath()));
            this.removeManager.remove(relationshipNode);
        }
        NodeIterator itProfile = this.session.getRootNode().getNode("exo:applications/Social_Profile").getNodes();
        while (itProfile.hasNext()) {
            Node profileNode = itProfile.nextNode();
            NodeIterator profileDetails = profileNode.getNodes();
            while (profileDetails.hasNext()) {
                Node profileDetail = profileDetails.nextNode();
                LOG.info((Object)("Removing profile " + profileDetail.getPath()));
                this.removeManager.remove(profileDetail);
            }
            this.removeManager.remove(profileNode);
        }
        NodeIterator itSpace = this.session.getRootNode().getNode("exo:applications/Social_Space/Space").getNodes();
        while (itSpace.hasNext()) {
            Node spaceNode = itSpace.nextNode();
            LOG.info((Object)("Removing space " + spaceNode.getPath()));
            this.removeManager.remove(spaceNode);
        }
        NodeIterator itIdentity = this.session.getRootNode().getNode("exo:applications/Social_Identity").getNodes();
        while (itIdentity.hasNext()) {
            Node identityNode = itIdentity.nextNode();
            LOG.info((Object)("Removing identity " + identityNode.getPath()));
            this.removeManager.remove(identityNode);
        }
        this.removeManager.remove(this.session.getRootNode().getNode("exo:applications"));
        this.removeManager.complete();
        ctx.cleanup();
        ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
        nodeTypeManager.unregisterNodeTypes(new String[]{"exo:identity", "exo:profile", "exo:profileKeyValue", "exo:profileExperience", "exo:profileEducation", "exo:profileAddress", "exo:relationshipProperty", "exo:relationship", "exo:activity", "exo:space"});
        this.session.save();
    }

    private void removeRelationNode(Node current, String nodeName) {
        try {
            NodeIterator relationships = current.getNode(nodeName).getNodes();
            while (relationships.hasNext()) {
                this.removeRelationship(relationships.nextNode());
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
    }

    private void removeRelationship(Node relationship) {
        try {
            this.removeManager.remove(relationship.getProperty("soc:reciprocal").getNode());
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
    }

    private boolean isOrganizationActivity(NodeData data) {
        return data.getPath().startsWith("/exo:applications/Social_Activity/organization");
    }

    private boolean isSpaceActivity(NodeData data) {
        return data.getPath().startsWith("/exo:applications/Social_Activity/space");
    }

    private String extractOwner(NodeData data) {
        return data.getPath().split("/")[4];
    }

    private Map<String, String> readParams(String[] params) {
        if (params != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String param : params) {
                String[] keyValue = param.split("=");
                if (keyValue.length < 2) {
                    paramMap.put(keyValue[0], null);
                    continue;
                }
                paramMap.put(keyValue[0], keyValue[1]);
            }
            if (paramMap.size() > 0) {
                return paramMap;
            }
        }
        return null;
    }

    private ExoSocialActivity buildActivityFromNode(Node node, WriterContext ctx) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        String title = this.getPropertyValue(node, "exo:title");
        String titleTemplate = this.getPropertyValue(node, "exo:titleTemplate");
        String type = this.getPropertyValue(node, "exo:type");
        String userId = this.getPropertyValue(node, "exo:userId");
        String postedTime = this.getPropertyValue(node, "exo:postedTime");
        String updatedTimestamp = this.getPropertyValue(node, "exo:updatedTimestamp");
        comment.setTitle(title);
        comment.setTitleId(titleTemplate);
        comment.setType(type);
        comment.setPostedTime(Long.valueOf(Long.parseLong(postedTime)));
        comment.setUpdated(new Date(Long.parseLong(updatedTimestamp)));
        String userName = ctx.get(userId + "-" + "remoteId");
        Identity newUser = this.identityStorage.findIdentity("organization", userName);
        if (newUser != null) {
            comment.setUserId(newUser.getId());
        }
        return comment;
    }

    private String getPropertyValue(Node node, String propertyName) {
        try {
            return node.getProperty(propertyName).getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private String[] checkUser(String[] users) {
        if (users == null) {
            return null;
        }
        ArrayList<String> checked = new ArrayList<String>();
        for (String user : users) {
            Identity i = this.identityStorage.findIdentity("organization", user);
            if (i == null) continue;
            checked.add(user);
        }
        return checked.toArray(new String[0]);
    }

    private Identity handleProfileBasic(NodeData currentData, WriterContext ctx) {
        Identity currentIdentity = null;
        Node avatarContent = null;
        String url = (String)currentData.get("Url");
        String firstName = (String)currentData.get("firstName");
        String lastName = (String)currentData.get("lastName");
        String position = (String)currentData.get("position");
        String username = (String)currentData.get("username");
        String gender = (String)currentData.get("gender");
        String identityOld = (String)currentData.get("exo:identity");
        String identityId = ctx.get(identityOld + "-" + "id");
        if (identityId != null) {
            currentIdentity = this.identityStorage.findIdentityById(identityId);
            username = currentIdentity.getRemoteId();
            try {
                avatarContent = this.session.getRootNode().getNode(currentData.getPath().substring(1) + "/avatar/jcr:content");
            }
            catch (RepositoryException e) {
                LOG.error((Object)e.getMessage());
            }
        } else {
            String spaceId = ctx.get(identityOld + "-" + "remoteId");
            if (spaceId != null) {
                try {
                    Node node = this.session.getNodeByUUID(spaceId);
                    String groupId = node.getProperty("exo:groupId").getString();
                    int lastSlash = groupId.lastIndexOf("/");
                    String groupName = groupId.substring(lastSlash + 1);
                    currentIdentity = this.identityStorage.findIdentity("space", groupName);
                    avatarContent = node.getNode("image/jcr:content");
                    Space space = this.spaceStorage.getSpaceByPrettyName(groupName);
                    if (space != null) {
                        space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
                        this.spaceStorage.saveSpace(space, false);
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)e.getMessage());
                }
            } else {
                return null;
            }
        }
        Profile profile = new Profile(currentIdentity);
        profile.setProperty("Url", (Object)url);
        profile.setProperty("firstName", (Object)firstName);
        profile.setProperty("lastName", (Object)lastName);
        profile.setProperty("fullName", (Object)(firstName + " " + lastName));
        profile.setProperty("position", (Object)position);
        profile.setProperty("username", (Object)username);
        profile.setProperty("gender", (Object)gender);
        profile.setProperty("ims", new ArrayList());
        profile.setProperty("phones", new ArrayList());
        profile.setProperty("urls", new ArrayList());
        try {
            String email = this.organizationService.getUserHandler().findUserByName(username).getEmail();
            profile.setProperty("email", (Object)email);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        try {
            String mime = avatarContent.getProperty("jcr:mimeType").getString();
            InputStream contentStream = avatarContent.getProperty("jcr:data").getStream();
            AvatarAttachment avatarAttachment = new AvatarAttachment();
            avatarAttachment.setMimeType(mime);
            avatarAttachment.setInputStream(contentStream);
            profile.setProperty("avatar", (Object)avatarAttachment);
            currentIdentity.setProfile(profile);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        try {
            this.identityStorage.saveProfile(profile);
            LOG.info((Object)("Write profile " + currentIdentity.getProviderId() + "/" + currentIdentity.getRemoteId()));
            ctx.incDone(WriterContext.DataType.PROFILES);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        return currentIdentity;
    }

    private void handleProfileContact(NodeData currentData, Identity identity) {
        if (identity == null) {
            return;
        }
        Profile profile = identity.getProfile();
        profile = this.identityStorage.loadProfile(profile);
        String path = currentData.getPath();
        String key = (String)currentData.get("key");
        String value = (String)currentData.get("value");
        String contactType = null;
        if (path.endsWith("ims")) {
            contactType = "ims";
        } else if (path.endsWith("phones")) {
            contactType = "phones";
        } else if (path.endsWith("urls")) {
            contactType = "urls";
        }
        if (contactType == null) {
            return;
        }
        ArrayList data = (ArrayList)profile.getProperty(contactType);
        if (data == null) {
            data = new ArrayList();
        }
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("key", key);
        info.put("value", value);
        data.add(info);
        profile.setProperty(contactType, data);
        this.identityStorage.saveProfile(profile);
    }

    private void handleProfileXp(NodeData currentData, Identity identity) {
        if (identity == null) {
            return;
        }
        Profile profile = identity.getProfile();
        profile = this.identityStorage.loadProfile(profile);
        String position = (String)currentData.get("position");
        String skills = (String)currentData.get("skills");
        String company = (String)currentData.get("company");
        String startDate = (String)currentData.get("startDate");
        String endDate = (String)currentData.get("endDate");
        String isCurrent = (String)currentData.get("isCurrent");
        String description = (String)currentData.get("exo:description");
        ArrayList xps = (ArrayList)profile.getProperty("experiences");
        if (xps == null) {
            xps = new ArrayList();
        }
        HashMap<String, Object> xp = new HashMap<String, Object>();
        xp.put("skills", skills);
        xp.put("position", position);
        xp.put("company", company);
        xp.put("description", description);
        xp.put("startDate", startDate);
        xp.put("endDate", endDate);
        xp.put("isCurrent", Boolean.valueOf(isCurrent));
        xps.add(xp);
        profile.setProperty("experiences", xps);
        this.identityStorage.saveProfile(profile);
    }
}

