/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.samples.website.extention.webui;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.platform.samples.website.extention.webui.UINavigationSelector;
import org.exoplatform.platform.samples.website.extention.webui.UINavigationTree;
import org.exoplatform.platform.webui.navigation.TreeNode;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UINavigationTreeBuilder
extends UIContainer {
    private UserNavigation edittedNavigation;
    private TreeNode edittedTreeNodeData;
    protected UserNode currentNode;

    public UINavigationTreeBuilder() throws Exception {
        UITree uiTree = (UITree)this.addChild(UINavigationTree.class, null, UINavigationTree.class.getSimpleName() + ((Object)((Object)this)).hashCode());
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("URI");
        uiTree.setBeanLabelField("encodedResolvedLabel");
        uiTree.setBeanIconField("icon");
        uiTree.setUIRightClickPopupMenu(null);
        UserNavigation edittedNavigation = this.getUserPortal().getNavigation(SiteKey.portal((String)this.getSiteName()));
        this.setEdittedNavigation(edittedNavigation);
        this.initTreeData();
    }

    private UserPortal getUserPortal() {
        UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
        return userPortal;
    }

    public String getSiteName() throws UnsupportedEncodingException {
        PortalRequestContext prContext = Util.getPortalRequestContext();
        String portalName = URLEncoder.encode(prContext.getPortalOwner(), "UTF-8");
        return portalName;
    }

    public void initTreeData() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.localizeNavigation(requestContext.getLocale());
        this.initEdittedTreeNodeData();
    }

    private void initEdittedTreeNodeData() throws Exception {
        if (this.edittedNavigation == null) {
            return;
        }
        if (this.edittedTreeNodeData == null) {
            this.edittedTreeNodeData = new TreeNode(this.edittedNavigation, Util.getUIPortal().getSelectedUserNode());
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        tree.setSibbling(this.getNodes(this.edittedNavigation));
    }

    private Collection<UserNode> getNodes(UserNavigation navigation) {
        return this.getUserPortal().getNode(navigation, Scope.ALL, null, null).getChildren();
    }

    private void localizeNavigation(Locale locale) {
        LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(locale.getLanguage());
        SiteType ownerType = this.edittedNavigation.getKey().getType();
        if (!SiteType.USER.equals((Object)ownerType)) {
            String ownerId = this.edittedNavigation.getKey().getName();
            if (SiteType.GROUP.equals((Object)ownerType)) {
                ownerId = ownerId.substring(1);
            }
            ResourceBundle res = localeConfig.getNavigationResourceBundle(ownerType.getName(), ownerId);
            for (UserNode node : this.getNodes(this.edittedNavigation)) {
                this.resolveLabel(res, node);
            }
        }
    }

    private void resolveLabel(ResourceBundle res, UserNode node) {
        if (node.getChildren() == null) {
            return;
        }
        for (UserNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    public void selectUserNodeByUri(String uri) {
        if (this.edittedTreeNodeData == null) {
            return;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        Collection sibbling = tree.getSibbling();
        tree.setSibbling(null);
        tree.setParentSelected(null);
        this.edittedTreeNodeData.setPageRef(this.searchUserNodeByUri(this.edittedTreeNodeData.getPageNavigation(), uri).getPageRef());
        if (this.edittedTreeNodeData.getNode() != null) {
            tree.setSelected((Object)this.edittedTreeNodeData.getNode());
            tree.setChildren(this.edittedTreeNodeData.getNode().getChildren());
            return;
        }
        tree.setSelected(null);
        tree.setChildren(null);
        tree.setSibbling(sibbling);
    }

    public UserNode searchUserNodeByUri(UserNavigation pageNav, String uri) {
        if (pageNav == null || uri == null) {
            return null;
        }
        Collection<UserNode> UserNodes = this.getNodes(pageNav);
        UITree uiTree = (UITree)this.getChild(UITree.class);
        for (UserNode ele : UserNodes) {
            UserNode returnUserNode = this.searchUserNodeByUri(ele, uri, uiTree);
            if (returnUserNode == null) continue;
            if (uiTree.getSibbling() == null) {
                uiTree.setSibbling(UserNodes);
            }
            return returnUserNode;
        }
        return null;
    }

    private UserNode searchUserNodeByUri(UserNode userNode, String uri, UITree tree) {
        if (userNode.getURI().equals(uri)) {
            return userNode;
        }
        Collection children = userNode.getChildren();
        if (children == null) {
            return null;
        }
        for (UserNode ele : children) {
            UserNode returnUserNode = this.searchUserNodeByUri(ele, uri, tree);
            if (returnUserNode == null) continue;
            if (tree.getSibbling() == null) {
                tree.setSibbling(children);
            }
            if (tree.getParentSelected() == null) {
                tree.setParentSelected((Object)userNode);
            }
            this.edittedTreeNodeData.getParent().setPageRef(userNode.getPageRef());
            return returnUserNode;
        }
        return null;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        UINavigationTree tree = (UINavigationTree)this.getChild(UINavigationTree.class);
        UserNode selectedNode = this.getSelectedUserNode();
        tree.setSelected(selectedNode);
        if (sibbling != null) {
            tree.setSibbling(this.filfer(sibbling));
        }
    }

    private List<Node> filfer(NodeIterator iterator) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node sibbling = iterator.nextNode();
            if (sibbling.isNodeType("exo:hiddenable")) continue;
            list.add(sibbling);
        }
        return list;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        writer.write("<div class=\"Explorer\">");
        writer.write("<div class=\"ExplorerTree\">");
        writer.write("<div class=\"InnerExplorerTree\">");
        this.buildTree();
        super.renderChildren();
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
    }

    public void changeNode(String uri, Object context) throws Exception {
        this.currentNode = this.searchUserNodeByUri(this.edittedTreeNodeData.getPageNavigation(), uri);
        this.broadcastOnChange(this.currentNode, context);
    }

    public void broadcastOnChange(UserNode navigationNode, Object context) throws Exception {
        UINavigationSelector nodeTreeSelector = (UINavigationSelector)this.getAncestorOfType(UINavigationSelector.class);
        nodeTreeSelector.onChange(navigationNode, context);
    }

    public void setEdittedNavigation(UserNavigation _filteredEdittedNavigation) throws Exception {
        this.edittedNavigation = _filteredEdittedNavigation;
    }

    public UserNavigation getEdittedNavigation() {
        return this.edittedNavigation;
    }

    public TreeNode getSelectedNode() {
        return this.edittedTreeNodeData;
    }

    public UserNavigation getSelectedNavigation() {
        return this.edittedTreeNodeData == null ? null : this.edittedTreeNodeData.getPageNavigation();
    }

    public UserNode getSelectedUserNode() {
        return this.edittedTreeNodeData == null ? null : this.edittedTreeNodeData.getNode();
    }

    public String getUpLevelUri() {
        return this.edittedTreeNodeData.getParent().getURI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UINavigationTreeBuilder builder = (UINavigationTreeBuilder)((UITree)event.getSource()).getParent();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            builder.selectUserNodeByUri(uri);
            builder.changeNode(uri, event.getRequestContext());
            UINavigationSelector nodeTreeSelector = (UINavigationSelector)builder.getAncestorOfType(UINavigationSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)nodeTreeSelector);
        }
    }
}

