/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.Hashtable;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.social.webui.activity.UIActivityExtension;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

public class UIActivityFactory
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(UIActivityFactory.class);
    private Hashtable<String, BaseUIActivityBuilder> builders = new Hashtable();
    UIExtensionManager extensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);

    public UIActivityFactory() {
        List extensions = this.extensionManager.getUIExtensions(BaseUIActivity.class.getName());
        for (UIExtension extension : extensions) {
            try {
                this.registerBuilder((UIActivityExtension)extension);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public BaseUIActivity addChild(ExoSocialActivity activity, UIContainer parent) throws Exception {
        String type = activity.getType();
        String externalId = activity.getExternalId();
        if (type != null) {
            return this.buildActivity(activity, parent, type);
        }
        if (externalId != null) {
            return this.buildActivity(activity, parent, externalId);
        }
        return this.buildActivity(activity, parent, "DEFAULT_ACTIVITY");
    }

    private BaseUIActivity buildActivity(ExoSocialActivity activity, UIContainer parent, String type) throws Exception {
        this.extensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);
        UIExtension activityExtension = this.extensionManager.getUIExtension(BaseUIActivity.class.getName(), type);
        if (activityExtension == null) {
            activityExtension = this.extensionManager.getUIExtension(BaseUIActivity.class.getName(), "DEFAULT_ACTIVITY");
        }
        BaseUIActivity uiActivity = (BaseUIActivity)this.extensionManager.addUIExtension(activityExtension, null, (org.exoplatform.webui.core.UIContainer)parent);
        uiActivity.setId(uiActivity.getId() + "_" + ((Object)((Object)uiActivity)).hashCode());
        BaseUIActivityBuilder builder = this.getBuilder(type);
        return builder.populateData(uiActivity, activity);
    }

    private BaseUIActivityBuilder getBuilder(String activityType) {
        BaseUIActivityBuilder builder = this.builders.get(activityType);
        if (builder == null) {
            builder = this.builders.get("DEFAULT_ACTIVITY");
        }
        return builder;
    }

    private void registerBuilder(UIActivityExtension activityExtension) throws Exception {
        String activityType = activityExtension.getName();
        if (this.builders.contains(activityType)) {
            this.builders.remove(activityType);
        }
        Class<?> builderClass = Thread.currentThread().getContextClassLoader().loadClass(activityExtension.getActivityBuiderClass());
        this.builders.put(activityType, (BaseUIActivityBuilder)builderClass.newInstance());
    }
}

