/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIBasicInfoSection;
import org.exoplatform.social.webui.profile.UIContactSection;
import org.exoplatform.social.webui.profile.UIExperienceSection;
import org.exoplatform.social.webui.profile.UIHeaderSection;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="classpath:groovy/social/webui/profile/UIProfile.gtmpl")
public class UIProfile
extends UIContainer {
    public UIProfile() throws Exception {
        List sections = this.getSections();
        for (Class sect : sections) {
            this.addChild(sect, null, null);
        }
    }

    public Profile getProfile() throws Exception {
        return Utils.getOwnerIdentity(true).getProfile();
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent) throws Exception {
        AvatarAttachment attacthment = uiAvatarUploadContent.getAvatarAttachment();
        Profile p = this.getProfile();
        p.setProperty("avatar", (Object)attacthment);
        Map props = p.getProperties();
        for (String key : props.keySet()) {
            if (!key.startsWith("avatar_")) continue;
            p.removeProperty(key);
        }
        Utils.getIdentityManager().updateProfile(p);
    }

    private List getSections() {
        ArrayList<Class> sects = new ArrayList<Class>();
        sects.add(UIHeaderSection.class);
        sects.add(UIBasicInfoSection.class);
        sects.add(UIContactSection.class);
        sects.add(UIExperienceSection.class);
        return sects;
    }
}

