/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.RenamedMixin;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.webui.core.UIAdvancePageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiAdvanceSearchResult.gtmpl")
public class UIWikiAdvanceSearchResult
extends UIContainer {
    private String keyword;

    public UIWikiAdvanceSearchResult() throws Exception {
        this.addChild(UIAdvancePageIterator.class, null, "SearchResultPageIterator");
    }

    public void setResult(PageList<SearchResult> results) throws Exception {
        UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)this.getChild(UIAdvancePageIterator.class);
        pageIterator.setPageList(results);
        if (pageIterator.getPageList() != null) {
            pageIterator.getPageList().getPage(1);
        }
    }

    public PageList<SearchResult> getResults() {
        UIAdvancePageIterator pageIterator = (UIAdvancePageIterator)this.getChild(UIAdvancePageIterator.class);
        return pageIterator.getPageList();
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    protected String getKeyword() {
        return this.keyword;
    }

    protected String getDateFormat(Calendar cal) throws Exception {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        return df.format(cal.getTime());
    }

    protected PageImpl getPage(SearchResult result) {
        PageImpl page = null;
        try {
            if ("wiki:content".equals(result.getType()) || "wiki:attachment".equals(result.getType())) {
                AttachmentImpl searchContent = (AttachmentImpl)Utils.getObject((String)result.getPath(), (String)"wiki:attachment");
                page = searchContent.getParentPage();
            } else if ("wiki:page".equals(result.getType()) || "exo:wikihome".equals(result.getType())) {
                page = (PageImpl)Utils.getObject((String)result.getPath(), (String)"wiki:page");
            }
            return page;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Wiki getWiki(PageImpl page) {
        return page != null ? page.getWiki() : null;
    }

    protected String getOldPageTitleInSearchResult(PageImpl page, String pageTitle) throws Exception {
        if (pageTitle.indexOf(this.keyword) >= 0) {
            return "";
        }
        if (page.getRenamedMixin() != null) {
            RenamedMixin mix = page.getRenamedMixin();
            for (String id : mix.getOldPageIds()) {
                if (id.indexOf(this.keyword) < 0) continue;
                return UIWikiAdvanceSearchResult.replaceUnderscorebySpace(id);
            }
        }
        return "";
    }

    protected static String replaceUnderscorebySpace(String s) {
        StringTokenizer st = new StringTokenizer(s, "_", false);
        StringBuilder sb = new StringBuilder();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
        }
        while (st.hasMoreElements()) {
            sb.append(" ").append(st.nextElement());
        }
        return sb.toString();
    }
}

