/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSearchBox;
import org.exoplatform.wiki.webui.control.UIWikiToolBar;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiApplicationControlArea.gtmpl")
public class UIWikiApplicationControlArea
extends UIContainer {
    public UIWikiApplicationControlArea() throws Exception {
        this.addChild(UIWikiSearchBox.class, null, null);
        this.addChild(UIWikiToolBar.class, null, null);
        this.addChild(UIWikiBreadCrumb.class, null, null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIWikiBreadCrumb wikiBreadCrumb = (UIWikiBreadCrumb)this.findFirstComponentOfType(UIWikiBreadCrumb.class);
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        String currentActionLabel = this.getCurrentActionLabel();
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        wikiBreadCrumb.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), params.getPageId()));
        wikiBreadCrumb.setActionLabel(currentActionLabel);
        super.processRender(context);
    }

    private String getCurrentActionLabel() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        switch (wikiPortlet.getWikiMode()) {
            case EDITPAGE: {
                return "UIWikiPortlet.label.Edit-Page";
            }
            case ADDPAGE: {
                return "UIWikiPortlet.label.Add-Page";
            }
            case ADVANCEDSEARCH: {
                return "UIWikiPortlet.label.Advanced-Search";
            }
            case SHOWHISTORY: {
                return "UIWikiPortlet.label.Show-History";
            }
            case VIEWREVISION: {
                return "UIWikiPortlet.label.View-Revision";
            }
            case DELETEPAGE: {
                return "UIWikiPortlet.label.Delete-Confirm";
            }
            case EDITTEMPLATE: {
                return "UIWikiPortlet.label.Edit-Template";
            }
            case ADDTEMPLATE: {
                return "UIWikiPortlet.label.Add-Template";
            }
            case COMPAREREVISION: {
                return "UIWikiPortlet.label.Compare-Revision";
            }
            case SPACESETTING: {
                return "UIWikiPortlet.label.Setting";
            }
        }
        return "";
    }
}

