/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiBreadCrumb.gtmpl")
public class UIWikiBreadCrumb
extends UIContainer {
    private List<BreadcrumbData> breadCumbs = new ArrayList<BreadcrumbData>();
    private String actionLabel;
    private boolean isLink = true;

    public List<BreadcrumbData> getBreadCumbs() {
        return this.breadCumbs;
    }

    public void setBreadCumbs(List<BreadcrumbData> breadCumbs) {
        this.breadCumbs = breadCumbs;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public String getParentURL() throws Exception {
        if (this.breadCumbs.size() > 1) {
            return this.createActionLink(this.breadCumbs.get(this.breadCumbs.size() - 2));
        }
        return this.createActionLink(this.breadCumbs.get(0));
    }

    public boolean isLink() {
        return this.isLink;
    }

    public void setLink(boolean isLink) {
        this.isLink = isLink;
    }

    public WikiPageParams getPageParam() throws Exception {
        if (this.breadCumbs != null && this.breadCumbs.size() > 0) {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            return wservice.getWikiPageParams(this.breadCumbs.get(this.breadCumbs.size() - 1));
        }
        return null;
    }

    public String getWikiType() throws Exception {
        if (this.getPageParam() != null) {
            return this.getPageParam().getType();
        }
        return null;
    }

    public String getWikiName() throws Exception {
        if (this.getPageParam() != null) {
            return this.getPageParam().getOwner();
        }
        return null;
    }

    public String createActionLink(BreadcrumbData breadCumbData) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder sb = new StringBuilder(portalRequestContext.getPortalURI());
        UIPortal uiPortal = Util.getUIPortal();
        String pageNodeSelected = uiPortal.getSelectedUserNode().getURI();
        sb.append(pageNodeSelected);
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(breadCumbData.getWikiType())) {
            sb.append(breadCumbData.getWikiType());
            sb.append("/");
            sb.append(Utils.validateWikiOwner((String)breadCumbData.getWikiType(), (String)breadCumbData.getWikiOwner()));
            sb.append("/");
        }
        sb.append(breadCumbData.getId());
        return sb.toString();
    }
}

