/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.bean;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.wiki.webui.bean.TemplateBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiTemplateListAccess
implements ListAccess<TemplateBean> {
    private final List<TemplateBean> list;

    public WikiTemplateListAccess(List<TemplateBean> list) {
        this.list = list;
    }

    public TemplateBean[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        if (index + length > this.list.size()) {
            throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
        }
        TemplateBean[] result = new TemplateBean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.list.get(i + index);
        }
        return result;
    }

    public int getSize() throws Exception {
        return this.list.size();
    }
}

