/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.AddContainerActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={AddPageActionListener.class})})
public class AddPageActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "AddPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPageActionListener
    extends AddContainerActionListener<AddPageActionComponent> {
        @Override
        protected void processEvent(Event<AddPageActionComponent> event) throws Exception {
            UIWikiRichTextArea wikiRichTextArea;
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((AddPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            String pageTitle = pageParams.getParameter("pageTitle");
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            titleInput.setValue((Object)res.getString("UIWikiPageTitleControlArea.label.Untitled"));
            titleInput.setEditable(true);
            markupInput.setValue((Object)"");
            commentInput.setRendered(false);
            WikiService wikiService = (WikiService)wikiPortlet.getApplicationComponent(WikiService.class);
            String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
            wikiService.createDraftNewPage(sessionId);
            String currentDefaultSyntaxt = Utils.getCurrentPreferences().getPreferencesSyntax().getDefaultSyntax();
            if (currentDefaultSyntaxt == null) {
                currentDefaultSyntaxt = wservice.getDefaultWikiSyntaxId();
            }
            if (pageTitle != null && pageTitle.length() > 0) {
                titleInput.setValue((Object)pageTitle);
                titleInput.setEditable(false);
            }
            if ((wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class)).isRendered()) {
                Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
            }
            wikiPortlet.changeMode(WikiMode.ADDPAGE);
            super.processEvent(event);
        }
    }
}

