/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageContainer;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.control.filter.IsEditAddModeFilter;
import org.exoplatform.wiki.webui.control.filter.IsEditAddPageModeFilter;
import org.exoplatform.wiki.webui.control.listener.UIEditorTabsActionListener;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/wiki/webui/control/action/RichTextActionComponent.gtmpl", events={@EventConfig(listeners={RichTextActionListener.class}, phase=Event.Phase.DECODE)})
public class RichTextActionComponent
extends UIComponent {
    public static final String ACTION = "RichText";
    public static final String RICHTEXT_LABEL = "RichText";
    public static final String SOURCETEXT_LABEL = "SourceEditor";
    protected String label = "RichText";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddModeFilter(), new IsEditAddPageModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIWikiPortlet portlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        String isMarkupMode = portlet.getUIExtContext().get("isMarkup").toString();
        if (isMarkupMode != null) {
            this.label = Boolean.valueOf(isMarkupMode) != false ? "RichText" : SOURCETEXT_LABEL;
        }
        super.processRender(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RichTextActionListener
    extends UIEditorTabsActionListener<RichTextActionComponent> {
        @Override
        protected void processEvent(Event<RichTextActionComponent> event) throws Exception {
            RichTextActionComponent component = (RichTextActionComponent)((Object)event.getSource());
            UIWikiPageEditForm wikiPageEditForm = (UIWikiPageEditForm)component.getAncestorOfType(UIWikiPageEditForm.class);
            UIWikiPageContainer pageCotainer = (UIWikiPageContainer)wikiPageEditForm.getAncestorOfType(UIWikiPageContainer.class);
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)pageCotainer.getChild(UIWikiBottomArea.class);
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)wikiPageEditForm.getChild(UIWikiRichTextArea.class);
            UIWikiSidePanelArea wikiSidePanelArea = (UIWikiSidePanelArea)wikiPageEditForm.getChild(UIWikiSidePanelArea.class);
            boolean isSourceTextRendered = wikiRichTextArea.isRendered();
            wikiRichTextArea.setRendered(!isSourceTextRendered);
            wikiPageEditForm.getUIFormTextAreaInput("Markup").setRendered(isSourceTextRendered);
            RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
            if (isSourceTextRendered) {
                String htmlContent = (String)wikiRichTextArea.getUIFormTextAreaInput().getValue();
                htmlContent = htmlContent == null ? "" : htmlContent;
                String markupSyntax = Utils.getDefaultSyntax();
                String markupContent = renderingService.render(htmlContent, Syntax.XHTML_1_0.toIdString(), markupSyntax, false);
                wikiPageEditForm.getUIFormTextAreaInput("Markup").setValue((Object)markupContent);
                wikiSidePanelArea.setRendered(true);
                bottomArea.setRendered(true);
            } else {
                Utils.feedDataForWYSIWYGEditor(wikiPageEditForm, null);
                wikiSidePanelArea.setRendered(false);
                bottomArea.setRendered(false);
            }
            super.processEvent(event);
            event.getRequestContext().addUIComponentToUpdateByAjax(pageCotainer.getAncestorOfType(UIWikiPortlet.class));
        }
    }
}

