/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.extension;

import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageContainer;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.commons.UIWikiTemplateForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/extension/UITemplateSettingForm.gtmpl", events={@EventConfig(listeners={AddTemplateActionListener.class}), @EventConfig(listeners={EditTemplateActionListener.class}), @EventConfig(listeners={UIWikiTemplateForm.SearchTemplateActionListener.class}), @EventConfig(listeners={DeleteTemplateActionListener.class}, confirm="UITemplateSettingForm.label.DeleteConfirm")})
public class UITemplateSettingForm
extends UIWikiTemplateForm {
    public static final String ACTION_ADD = "AddTemplate";
    public static final String ACTION_DELETE = "DeleteTemplate";
    public static final String ACTION_EDIT = "EditTemplate";
    public static final String ACTION_SEARCH = "SearchTemplate";
    private static final String[] USER_ACTION = new String[]{"EditTemplate", "DeleteTemplate"};

    public UITemplateSettingForm() throws Exception {
        this.grid.configure("id", TEMPLATE_FIELD, USER_ACTION);
    }

    public ResourceBundle getRes() {
        return this.res;
    }

    public void setRes(ResourceBundle res) {
        this.res = res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTemplateActionListener
    extends EventListener<UITemplateSettingForm> {
        public void execute(Event<UITemplateSettingForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UITemplateSettingForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            ResourceBundle res = ((UITemplateSettingForm)((Object)event.getSource())).getRes();
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormStringInput descriptionInput = (UIFormStringInput)pageEditForm.findComponentById("Description");
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            String currentDefaultSyntaxt = Utils.getCurrentPreferences().getPreferencesSyntax().getDefaultSyntax();
            if (currentDefaultSyntaxt == null) {
                currentDefaultSyntaxt = wservice.getDefaultWikiSyntaxId();
            }
            titleInput.setValue((Object)res.getString("UIWikiPageEditForm.label.SampleTemplateTitle"));
            descriptionInput.setValue((Object)res.getString("UIWikiPageEditForm.label.Description"));
            titleInput.setEditable(true);
            commentInput.setRendered(false);
            markupInput.setValue((Object)"");
            String sessionId = Util.getPortalRequestContext().getRequest().getSession(false).getId();
            wservice.createDraftNewPage(sessionId);
            markupInput.setRendered(true);
            ((UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class)).setRendered(false);
            ((UIWikiSidePanelArea)pageEditForm.getChild(UIWikiSidePanelArea.class)).setRendered(true);
            ((UIWikiBottomArea)((UIWikiPageContainer)pageEditForm.getAncestorOfType(UIWikiPageContainer.class)).getChild(UIWikiBottomArea.class)).setRendered(true);
            wikiPortlet.changeMode(WikiMode.ADDTEMPLATE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteTemplateActionListener
    extends EventListener<UITemplateSettingForm> {
        public void execute(Event<UITemplateSettingForm> event) throws Exception {
            UITemplateSettingForm form = (UITemplateSettingForm)((Object)event.getSource());
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            String templateId = event.getRequestContext().getRequestParameter("objectId");
            form.wService.deleteTemplatePage(params.getType(), params.getOwner(), templateId);
            form.initGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)form);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditTemplateActionListener
    extends EventListener<UITemplateSettingForm> {
        public void execute(Event<UITemplateSettingForm> event) throws Exception {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UITemplateSettingForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormStringInput descriptionInput = (UIFormStringInput)pageEditForm.findComponentById("Description");
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            String templateId = event.getRequestContext().getRequestParameter("objectId");
            pageEditForm.setTemplateId(templateId);
            titleInput.setEditable(true);
            commentInput.setRendered(false);
            Template template = wservice.getTemplatePage(pageParams, templateId);
            titleInput.setValue((Object)template.getTitle());
            descriptionInput.setValue((Object)template.getDescription());
            pageEditForm.setTitle(template.getTitle());
            markupInput.setValue((Object)template.getContent().getText());
            markupInput.setRendered(true);
            ((UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class)).setRendered(false);
            ((UIWikiSidePanelArea)pageEditForm.getChild(UIWikiSidePanelArea.class)).setRendered(true);
            ((UIWikiBottomArea)((UIWikiPageContainer)pageEditForm.getAncestorOfType(UIWikiPageContainer.class)).getChild(UIWikiBottomArea.class)).setRendered(true);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.deActivate();
            wikiPortlet.changeMode(WikiMode.EDITTEMPLATE);
        }
    }
}

