/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.webui.UIWikiEmptyAjaxBlock;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.tree.EventUIComponent;
import org.exoplatform.wiki.webui.tree.UITreeExplorer;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="/templates/wiki/webui/popup/UIWikiSelectPageForm.gtmpl", events={@EventConfig(listeners={SetCurrentPageActionListener.class}), @EventConfig(listeners={SelectPageActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiSelectPageForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getLogger(UIWikiSelectPageForm.class);
    public static final String FORM_ID = "UIWikiSelectPageForm";
    private String currentNodeValue = "";
    public static final String UI_TREE_ID = "UIPageTree";
    private List<UIComponent> updatedComponents = new ArrayList<UIComponent>();

    public UIWikiSelectPageForm() throws Exception {
        this.setId(FORM_ID);
        UITreeExplorer uiTree = (UITreeExplorer)this.addChild(UITreeExplorer.class, null, UI_TREE_ID);
        EventUIComponent eventComponent = new EventUIComponent(FORM_ID, "SetCurrentPage", EventUIComponent.EVENTTYPE.EVENT);
        StringBuilder initURLSb = new StringBuilder(Utils.getCurrentRestURL());
        initURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.ALL.toString());
        StringBuilder childrenURLSb = new StringBuilder(Utils.getCurrentRestURL());
        childrenURLSb.append("/wiki/tree/").append(TreeNode.TREETYPE.CHILDREN.toString());
        uiTree.init(initURLSb.toString(), childrenURLSb.toString(), this.getInitParam(), eventComponent, false);
    }

    public void addUpdatedComponent(UIComponent component) {
        this.updatedComponents.add(component);
    }

    public void removeUpdatedComponent(UIComponent component) {
        this.updatedComponents.remove(component);
    }

    private String getInitParam() throws Exception {
        StringBuilder sb = new StringBuilder();
        String currentPath = Utils.getCurrentWikiPagePath();
        sb.append("?").append("path").append("=").append(currentPath).append("&").append("page").append("=").append(currentPath);
        return sb.toString();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiSelectPageForm uiform = (UIWikiSelectPageForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPageActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiPortlet wikiPortlet;
            UIWikiSelectPageForm uiform;
            block4: {
                uiform = (UIWikiSelectPageForm)((Object)event.getSource());
                wikiPortlet = (UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class);
                try {
                    if (uiform.currentNodeValue.length() > 0) {
                        String currentNodeValue = TitleResolver.getId((String)uiform.currentNodeValue, (boolean)false);
                        WikiPageParams params = TreeUtils.getPageParamsFromPath((String)currentNodeValue);
                        WikiService service = (WikiService)uiform.getApplicationComponent(WikiService.class);
                        service.addRelatedPage(Utils.getCurrentWikiPageParams(), params);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)"can not execute 'SelectPage' action", (Throwable)e);
                }
            }
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            for (UIComponent c : uiform.updatedComponents) {
                event.getRequestContext().addUIComponentToUpdateByAjax(c);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetCurrentPageActionListener
    extends EventListener<UIWikiSelectPageForm> {
        public void execute(Event<UIWikiSelectPageForm> event) throws Exception {
            UIWikiSelectPageForm uiform = (UIWikiSelectPageForm)((Object)event.getSource());
            UIWikiEmptyAjaxBlock emptyBlock = (UIWikiEmptyAjaxBlock)((UIWikiPortlet)uiform.getAncestorOfType(UIWikiPortlet.class)).getChild(UIWikiEmptyAjaxBlock.class);
            String param = event.getRequestContext().getRequestParameter("objectId");
            if (param != null) {
                uiform.currentNodeValue = param;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)emptyBlock);
        }
    }
}

