/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.util;

import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ide.groovy.util.DependentResources;
import org.exoplatform.ide.groovy.util.GroovyClassPath;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class GroovyScriptServiceUtil {
    public static final String WEBDAV_CONTEXT = "/jcr/";
    public static final String GROOVY_CLASSPATH = ".groovyclasspath";

    public static GroovyClassPath json2ClassPath(InputStream stream) throws JsonException {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        jsonParser.parse(stream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        GroovyClassPath classPath = (GroovyClassPath)ObjectBuilder.createObject(GroovyClassPath.class, (JsonValue)jsonValue);
        return classPath;
    }

    public static String[] parseJcrLocation(String baseUri, String location) {
        if (!location.startsWith(baseUri = baseUri + WEBDAV_CONTEXT)) {
            return null;
        }
        String[] elements = new String[3];
        location = location.substring(baseUri.length());
        elements[0] = location.substring(0, location.indexOf(47));
        location = location.substring(location.indexOf(47) + 1);
        elements[1] = location.substring(0, location.indexOf(47));
        elements[2] = location.substring(location.indexOf(47) + 1);
        return elements;
    }

    public static Session getSession(RepositoryService repositoryService, SessionProviderService sessionProviderService, String repoName, String repoPath) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repo = repositoryService.getRepository(repoName);
        SessionProvider sp = sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        String workspace = repoPath.split("/")[0];
        return sp.getSession(workspace, repo);
    }

    public static Node findClassPathNode(Node node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        NodeIterator nodeIterator = node.getNodes("*.groovyclasspath");
        while (nodeIterator.hasNext()) {
            Node childNode = nodeIterator.nextNode();
            if (!GROOVY_CLASSPATH.equals(childNode.getName())) continue;
            return childNode;
        }
        try {
            Node parentNode = node.getParent();
            return GroovyScriptServiceUtil.findClassPathNode(parentNode);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (AccessDeniedException e) {
            return null;
        }
    }

    protected static InputStream getClassPathContent(String location, String baseUri, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        String[] jcrLocation = GroovyScriptServiceUtil.parseJcrLocation(baseUri, location);
        try {
            Session session = GroovyScriptServiceUtil.getSession(repositoryService, (SessionProviderService)sessionProviderService, jcrLocation[0], jcrLocation[1] + "/" + jcrLocation[2]);
            Node rootNode = session.getRootNode();
            Node scriptNode = rootNode.getNode(jcrLocation[2]);
            Node classpathNode = GroovyScriptServiceUtil.findClassPathNode(scriptNode.getParent());
            if (classpathNode != null) {
                return classpathNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            }
        }
        catch (RepositoryException e) {
            return null;
        }
        catch (RepositoryConfigurationException e) {
            return null;
        }
        return null;
    }

    public static DependentResources getDependentResource(String scriptLocation, String baseUri, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        InputStream classPathFileContent = GroovyScriptServiceUtil.getClassPathContent(scriptLocation, baseUri, repositoryService, sessionProviderService);
        if (classPathFileContent != null) {
            try {
                GroovyClassPath groovyClassPath = GroovyScriptServiceUtil.json2ClassPath(classPathFileContent);
                if (groovyClassPath != null) {
                    String repositoryName = repositoryService.getCurrentRepository() != null ? repositoryService.getCurrentRepository().getConfiguration().getName() : repositoryService.getDefaultRepository().getConfiguration().getName();
                    return new DependentResources(repositoryName, groovyClassPath);
                }
            }
            catch (JsonException e) {
                return null;
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                return null;
            }
            catch (RepositoryConfigurationException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

