/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IndexTool {
    private final Session session;
    private static final Log LOG = ExoLogger.getLogger(IndexTool.class);

    public IndexTool(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            Node organizationNode = this.session.getRootNode().getNode("production/soc:providers/soc:organization/");
            NodeIterator userIterator = organizationNode.getNodes();
            while (userIterator.hasNext()) {
                Node user = userIterator.nextNode();
                Node profileNode = user.getNode("soc:profile");
                NodeIterator subProfileNodeIterator = profileNode.getNodes();
                ArrayList<String> skills = new ArrayList<String>();
                while (subProfileNodeIterator.hasNext()) {
                    Node subProfileNode = subProfileNodeIterator.nextNode();
                    if (!subProfileNode.getPrimaryNodeType().getName().equals("soc:profilexp")) continue;
                    try {
                        String skillsValue = subProfileNode.getProperty("soc:skills").getString();
                        skills.add(skillsValue);
                    }
                    catch (PathNotFoundException e) {}
                }
                LOG.info((Object)("Index skills for " + user.getName()));
                profileNode.setProperty("index-skills", skills.toArray(new String[0]));
            }
        }
        catch (RepositoryException e) {
            LOG.info((Object)("Error during indexing profiles : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

