/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.config.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BlobCrypterSecurityTokenCodec
implements SecurityTokenCodec {
    public static final String SECURITY_TOKEN_KEY_FILE = "gadgets.securityTokenKeyFile";
    public static final String SIGNED_FETCH_DOMAIN = "gadgets.signedFetchDomain";
    protected final Map<String, BlobCrypter> crypters = Maps.newHashMap();
    protected final Map<String, String> domains = Maps.newHashMap();

    @Inject
    public BlobCrypterSecurityTokenCodec(ContainerConfig config) {
        try {
            for (String container : config.getContainers()) {
                String keyFile = config.getString(container, SECURITY_TOKEN_KEY_FILE);
                if (keyFile != null) {
                    BlobCrypter crypter = this.loadCrypterFromFile(new File(keyFile));
                    this.crypters.put(container, crypter);
                }
                String domain = config.getString(container, SIGNED_FETCH_DOMAIN);
                this.domains.put(container, domain);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected BlobCrypter loadCrypterFromFile(File file) throws IOException {
        return new BasicBlobCrypter(file);
    }

    @Override
    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        String token = tokenParameters.get("token");
        if (StringUtils.isBlank((String)token)) {
            return new AnonymousSecurityToken();
        }
        String[] fields = StringUtils.split((String)token, (char)':');
        if (fields.length != 2) {
            throw new SecurityTokenException("Invalid security token " + token);
        }
        String container = fields[0];
        BlobCrypter crypter = this.crypters.get(container);
        if (crypter == null) {
            throw new SecurityTokenException("Unknown container " + token);
        }
        String domain = this.domains.get(container);
        String activeUrl = tokenParameters.get("activeUrl");
        String crypted = fields[1];
        try {
            return BlobCrypterSecurityToken.decrypt(crypter, container, domain, crypted, activeUrl);
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
    }

    @Override
    public String encodeToken(SecurityToken token) throws SecurityTokenException {
        if (!(token instanceof BlobCrypterSecurityToken)) {
            throw new SecurityTokenException("Can only encode BlogCrypterSecurityTokens");
        }
        BlobCrypterSecurityToken t = (BlobCrypterSecurityToken)token;
        try {
            return t.encrypt();
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException(e);
        }
    }
}

