/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class BaseActionLauncherListener
implements ECMEventListener {
    protected String actionName_;
    protected String repository_;
    protected String srcWorkspace_;
    protected String srcPath_;
    protected String executable_;
    protected Map actionVariables_;
    private static final Log LOG = ExoLogger.getLogger((String)BaseActionLauncherListener.class.getName());

    public BaseActionLauncherListener(String actionName, String executable, String repository, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
        this.actionName_ = actionName;
        this.executable_ = executable;
        this.repository_ = repository;
        this.srcWorkspace_ = srcWorkspace;
        this.srcPath_ = srcPath;
        this.actionVariables_ = actionVariables;
    }

    public String getSrcWorkspace() {
        return this.srcWorkspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void onEvent(EventIterator events) {
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ActionServiceContainer actionServiceContainer = WCMCoreUtils.getService(ActionServiceContainer.class);
        IdentityRegistry identityRegistry = WCMCoreUtils.getService(IdentityRegistry.class);
        while (events.hasNext()) {
            Event event = events.nextEvent();
            Node node = null;
            Session jcrSession = null;
            try {
                jcrSession = repositoryService.getCurrentRepository().getSystemSession(this.srcWorkspace_);
                String repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
                node = (Node)jcrSession.getItem(this.srcPath_);
                String userId = event.getUserID();
                Node actionNode = actionServiceContainer.getAction(node, this.actionName_);
                Property rolesProp = actionNode.getProperty("exo:roles");
                Value[] roles = rolesProp.getValues();
                boolean hasPermission = this.checkExcetuteable(userId, roles, identityRegistry);
                if (!hasPermission) {
                    jcrSession.logout();
                    return;
                }
                String path = event.getPath();
                if (!this.checkAffectedNodeType(actionNode, jcrSession, path)) {
                    jcrSession.logout();
                    return;
                }
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("eventType", event.getType() + "");
                variables.put("initiator", userId);
                variables.put("actionName", this.actionName_);
                variables.put("nodePath", path);
                variables.put("repository", repoName);
                variables.put("srcWorkspace", this.srcWorkspace_);
                variables.put("srcPath", this.srcPath_);
                variables.putAll(this.actionVariables_);
                if (event.getType() == 1) {
                    block9: {
                        try {
                            node = (Node)jcrSession.getItem(path);
                        }
                        catch (Exception e) {
                            if (!path.contains("exo:actions")) break block9;
                            Node tempnode = (Node)jcrSession.getItem(path.substring(0, path.indexOf("exo:actions") - 1));
                            node = tempnode.getNodes("exo:actions").nextNode().getNode(path.substring(path.indexOf("exo:actions") + "exo:actions".length() + 1));
                        }
                    }
                    String nodeType = node.getPrimaryNodeType().getName();
                    variables.put("document-type", nodeType);
                    this.triggerAction(userId, variables, repoName);
                } else {
                    this.triggerAction(userId, variables, repoName);
                }
                jcrSession.logout();
            }
            catch (Exception e) {
                jcrSession.logout();
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public abstract void triggerAction(String var1, Map var2, String var3) throws Exception;

    private boolean checkExcetuteable(String userId, Value[] roles, IdentityRegistry identityRegistry) throws Exception {
        if (IdentityConstants.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        if (IdentityConstants.ANONIM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (identity == null || !identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAffectedNodeType(Node actionNode, Session session, String path) throws Exception {
        if (!session.itemExists(path)) {
            return true;
        }
        Item item = session.getItem(path);
        if (!item.isNode()) {
            return true;
        }
        if (!actionNode.hasProperty("exo:affectedNodeTypeNames")) {
            return true;
        }
        Value[] nodeTypes = actionNode.getProperty("exo:affectedNodeTypeNames").getValues();
        if (nodeTypes.length == 0) {
            return true;
        }
        for (Value nodeType : nodeTypes) {
            if (!((Node)item).isNodeType(nodeType.getString())) continue;
            return true;
        }
        return false;
    }
}

