/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;

public class OAuthSecurityToken
extends AbstractSecurityToken
implements SecurityToken {
    private final String userId;
    private final String appUrl;
    private final String appId;
    private final String domain;
    private final String container;
    private final String authMode;
    private final Long expiresAt;

    public OAuthSecurityToken(String userId, String appUrl, String appId, String domain, String container, Long expiresAt) {
        this(userId, appUrl, appId, domain, container, expiresAt, AuthenticationMode.OAUTH.name());
    }

    public OAuthSecurityToken(String userId, String appUrl, String appId, String domain, String container, Long expiresAt, String authMode) {
        this.userId = userId;
        this.appUrl = appUrl;
        this.appId = appId;
        this.domain = domain;
        this.container = container;
        this.authMode = authMode;
        this.expiresAt = null;
    }

    public String getOwnerId() {
        return this.userId;
    }

    public String getViewerId() {
        return this.userId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getContainer() {
        return this.container;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public long getModuleId() {
        throw new UnsupportedOperationException();
    }

    public String getUpdatedToken() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationMode() {
        return this.authMode;
    }

    public String getTrustedJson() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnonymous() {
        return false;
    }
}

