/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCreateNodeTypeEventListener
extends Listener<CmsService, String> {
    private WCMComposer composer;
    private TaxonomyService taxonomyService;
    private ActionServiceContainer actionServiceContainer;
    private static final String TAXONOMY_ACTION = "exo:taxonomyAction";

    public PostCreateNodeTypeEventListener(WCMComposer composer) {
        this.composer = composer;
    }

    public void onEvent(Event<CmsService, String> event) throws Exception {
        this.composer.cleanTemplates();
        this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        this.actionServiceContainer = (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class);
        String nodetypeName = (String)event.getData();
        List taxonomyTrees = this.taxonomyService.getAllTaxonomyTrees();
        for (Node taxonomyTree : taxonomyTrees) {
            Node action = null;
            List actions = this.actionServiceContainer.getActions(taxonomyTree);
            for (Node taxonomyAction : actions) {
                if (!taxonomyAction.isNodeType(TAXONOMY_ACTION)) continue;
                action = taxonomyAction;
                break;
            }
            if (action == null) continue;
            Session session = action.getSession();
            ValueFactory valueFactory = session.getValueFactory();
            Value[] values = action.getProperty("exo:affectedNodeTypeNames").getValues();
            ArrayList<Value> tmpValues = new ArrayList<Value>();
            for (Value value : values) {
                tmpValues.add(value);
            }
            tmpValues.add(valueFactory.createValue(nodetypeName));
            action.setProperty("exo:affectedNodeTypeNames", tmpValues.toArray(new Value[tmpValues.size()]));
            session.save();
        }
    }
}

